/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.codec;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fisco.bcos.sdk.v3.codec.abi.TypeMappingException;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.v3.codec.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.Fixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.Int;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticArray;
import org.fisco.bcos.sdk.v3.codec.datatypes.StaticStruct;
import org.fisco.bcos.sdk.v3.codec.datatypes.StructType;
import org.fisco.bcos.sdk.v3.codec.datatypes.Type;
import org.fisco.bcos.sdk.v3.codec.datatypes.TypeReference;
import org.fisco.bcos.sdk.v3.codec.datatypes.Ufixed;
import org.fisco.bcos.sdk.v3.codec.datatypes.Uint;
import org.fisco.bcos.sdk.v3.codec.datatypes.Utf8String;

public class Utils {
    private Utils() {
    }

    public static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        return Utils.getTypeName(typeReference.getType());
    }

    public static <T extends Type> String getTypeName(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (type instanceof ParameterizedType) {
                return Utils.getParameterizedTypeName(type);
            }
            return Utils.getSimpleTypeName(cls);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static <T extends Type, U extends Type> String getParameterizedTypeName(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (DynamicArray.class.isAssignableFrom(cls)) {
                return Utils.getTypeName(((ParameterizedType)type).getActualTypeArguments()[0]) + "[]";
            }
            if (StaticArray.class.isAssignableFrom(cls)) {
                int length = Integer.parseInt(cls.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                return Utils.getTypeName(((ParameterizedType)type).getActualTypeArguments()[0]) + "[" + length + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + cls.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    public static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            return type.getName();
        }
        return simpleName;
    }

    public static <T extends Type> boolean dynamicType(java.lang.reflect.Type type) throws ClassNotFoundException {
        Class<T> cls = Utils.getClassType(type);
        if (Utf8String.class.isAssignableFrom(cls) || DynamicBytes.class.isAssignableFrom(cls) || DynamicArray.class.isAssignableFrom(cls)) {
            return true;
        }
        if (!StaticArray.class.isAssignableFrom(cls)) {
            return false;
        }
        java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return Utils.dynamicType(types[0]);
    }

    public static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray && StaticStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                count += Utils.staticStructNestedPublicFieldsFlatList(((StaticArray)type).getComponentType()).size() * ((StaticArray)type).getValue().size();
                continue;
            }
            if (type instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                ++count;
                continue;
            }
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }

    public static List<Field> staticStructNestedPublicFieldsFlatList(Class<Type> classType) {
        return Utils.staticStructsNestedFieldsFlatList(classType).stream().filter(field -> Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
    }

    public static List<Field> staticStructsNestedFieldsFlatList(Class<Type> classType) {
        List canonicalFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> !StaticStruct.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        List nestedFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> StaticStruct.class.isAssignableFrom(field.getType())).map(field -> Utils.staticStructsNestedFieldsFlatList(field.getType())).flatMap(Collection::stream).collect(Collectors.toList());
        return Stream.concat(canonicalFields.stream(), nestedFields.stream()).collect(Collectors.toList());
    }

    public static <T extends Type> int getOffset(java.lang.reflect.Type type) throws ClassNotFoundException {
        if (Utils.dynamicType(type)) {
            return 1;
        }
        Class<T> cls = Utils.getClassType(type);
        if (StaticArray.class.isAssignableFrom(cls)) {
            int length = Integer.parseInt(cls.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
            java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            return Utils.getOffset(types[0]) * length;
        }
        return 1;
    }

    public static <T extends Type> Class<T> getClassType(java.lang.reflect.Type type) throws ClassNotFoundException {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Class.forName(type.getTypeName());
    }

    public static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return Utils.getClassType(types[0]);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(Utils.typeMap(ts, innerType));
                result.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    public static List typeMapWithoutGenericType(List input, Class destType) throws TypeMappingException {
        ArrayList result = new ArrayList(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (Object value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }
}

