/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client.protocol.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.v3.model.JsonRpcResponse;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;

public class ConsensusStatus
extends JsonRpcResponse<ConsensusStatusInfo> {
    public ConsensusStatusInfo getConsensusStatus() {
        return (ConsensusStatusInfo)this.getResult();
    }

    @Override
    @JsonDeserialize(converter=ConsensusStatusInfoConvert.class)
    public void setResult(ConsensusStatusInfo result) {
        super.setResult(result);
    }

    public static class ConsensusStatusInfoConvert
    implements Converter<String, ConsensusStatusInfo> {
        public ConsensusStatusInfo convert(String value) {
            try {
                return (ConsensusStatusInfo)ObjectMapperFactory.getObjectMapper().readValue(value, ConsensusStatusInfo.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(String.class, null);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(ConsensusStatusInfo.class, null);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConsensusStatusInfo {
        @JsonProperty(value="nodeID")
        private String nodeID;
        @JsonProperty(value="index")
        private String index;
        @JsonProperty(value="leaderIndex")
        private Integer leaderIndex;
        @JsonProperty(value="consensusNodesNum")
        private Integer consensusNodesNum;
        @JsonProperty(value="maxFaultyQuorum")
        private Integer maxFaultyQuorum;
        @JsonProperty(value="minRequiredQuorum")
        private Integer minRequiredQuorum;
        @JsonProperty(value="isConsensusNode")
        private Boolean isConsensusNode;
        @JsonProperty(value="blockNumber")
        private Integer blockNumber;
        @JsonProperty(value="hash")
        private String hash;
        @JsonProperty(value="timeout")
        private Boolean timeout;
        @JsonProperty(value="changeCycle")
        private Integer changeCycle;
        @JsonProperty(value="view")
        private Integer view;
        @JsonProperty(value="connectedNodeList")
        private Integer connectedNodeList;
        @JsonProperty(value="consensusNodeList")
        private List<ConsensusNodeInfo> consensusNodeInfos;

        public String getNodeID() {
            return this.nodeID;
        }

        public void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public Integer getLeaderIndex() {
            return this.leaderIndex;
        }

        public void setLeaderIndex(Integer leaderIndex) {
            this.leaderIndex = leaderIndex;
        }

        public Integer getConsensusNodesNum() {
            return this.consensusNodesNum;
        }

        public void setConsensusNodesNum(Integer consensusNodesNum) {
            this.consensusNodesNum = consensusNodesNum;
        }

        public Integer getMaxFaultyQuorum() {
            return this.maxFaultyQuorum;
        }

        public void setMaxFaultyQuorum(Integer maxFaultyQuorum) {
            this.maxFaultyQuorum = maxFaultyQuorum;
        }

        public Integer getMinRequiredQuorum() {
            return this.minRequiredQuorum;
        }

        public void setMinRequiredQuorum(Integer minRequiredQuorum) {
            this.minRequiredQuorum = minRequiredQuorum;
        }

        public boolean isConsensusNode() {
            return this.isConsensusNode;
        }

        public void setConsensusNode(boolean consensusNode) {
            this.isConsensusNode = consensusNode;
        }

        public Integer getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(Integer blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public Boolean getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Boolean timeout) {
            this.timeout = timeout;
        }

        public Integer getChangeCycle() {
            return this.changeCycle;
        }

        public void setChangeCycle(Integer changeCycle) {
            this.changeCycle = changeCycle;
        }

        public Integer getView() {
            return this.view;
        }

        public void setView(Integer view) {
            this.view = view;
        }

        public Boolean getConsensusNode() {
            return this.isConsensusNode;
        }

        public void setConsensusNode(Boolean consensusNode) {
            this.isConsensusNode = consensusNode;
        }

        public Integer getConnectedNodeList() {
            return this.connectedNodeList;
        }

        public void setConnectedNodeList(Integer connectedNodeList) {
            this.connectedNodeList = connectedNodeList;
        }

        public List<ConsensusNodeInfo> getConsensusNodeInfos() {
            return this.consensusNodeInfos;
        }

        public void setConsensusNodeInfos(List<ConsensusNodeInfo> consensusNodeInfos) {
            this.consensusNodeInfos = consensusNodeInfos;
        }

        public String toString() {
            return "ConsensusStatusInfo{nodeID='" + this.nodeID + '\'' + ", index=" + this.index + ", leaderIndex=" + this.leaderIndex + ", consensusNodesNum=" + this.consensusNodesNum + ", maxFaultyQuorum=" + this.maxFaultyQuorum + ", minRequiredQuorum=" + this.minRequiredQuorum + ", isConsensusNode=" + this.isConsensusNode + ", blockNumber=" + this.blockNumber + ", hash='" + this.hash + '\'' + ", timeout=" + this.timeout + ", changeCycle=" + this.changeCycle + ", view=" + this.view + ", connectedNodeList=" + this.connectedNodeList + ", consensusNodeInfos=" + this.consensusNodeInfos + '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConsensusNodeInfo {
        @JsonProperty(value="nodeID")
        private String nodeID;
        @JsonProperty(value="weight")
        private Integer weight;
        @JsonProperty(value="index")
        private Integer index;

        public String getNodeID() {
            return this.nodeID;
        }

        public void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String toString() {
            return "ConsensusNodeInfo{nodeID='" + this.nodeID + '\'' + ", weight='" + this.weight + '\'' + ", index='" + this.index + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsensusNodeInfo that = (ConsensusNodeInfo)o;
            return Objects.equals(this.nodeID, that.nodeID) && Objects.equals(this.weight, that.weight) && Objects.equals(this.index, that.index);
        }

        public int hashCode() {
            return Objects.hash(this.nodeID, this.weight, this.index);
        }
    }
}

