/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client.protocol.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.util.List;
import org.fisco.bcos.sdk.v3.client.protocol.model.GroupNodeIniInfo;
import org.fisco.bcos.sdk.v3.model.JsonRpcResponse;
import org.fisco.bcos.sdk.v3.utils.ObjectMapperFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BcosGroupNodeInfo
extends JsonRpcResponse<GroupNodeInfo> {
    @Override
    public GroupNodeInfo getResult() {
        return (GroupNodeInfo)super.getResult();
    }

    @Override
    @JsonDeserialize(using=GroupNodeInfoDeserializer.class)
    public void setResult(GroupNodeInfo result) {
        super.setResult(result);
    }

    public static class GroupNodeIniInfoConvert
    implements Converter<String, GroupNodeIniInfo> {
        public GroupNodeIniInfo convert(String value) {
            try {
                return (GroupNodeIniInfo)ObjectMapperFactory.getObjectMapper().readValue(value, GroupNodeIniInfo.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(String.class, null);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructSimpleType(GroupNodeIniInfo.class, null);
        }
    }

    public static class GroupNodeInfoDeserializer
    extends JsonDeserializer<GroupNodeInfo> {
        private final ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public GroupNodeInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (GroupNodeInfo)this.objectReader.readValue(jsonParser, GroupNodeInfo.class);
            }
            return null;
        }
    }

    public static class GroupNodeInfo {
        private int type;
        private GroupNodeIniInfo iniConfig;
        private String name;
        private List<ServiceInfo> serviceInfoList;
        private Protocol protocol;

        public String toString() {
            return "GroupNodeInfo{type=" + this.type + ", iniConfig=" + this.iniConfig + ", name='" + this.name + '\'' + ", serviceInfoList=" + this.serviceInfoList + ", protocol=" + this.protocol + '}';
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }

        public GroupNodeIniInfo getIniConfig() {
            return this.iniConfig;
        }

        @JsonDeserialize(converter=GroupNodeIniInfoConvert.class)
        public void setIniConfig(GroupNodeIniInfo iniConfig) {
            this.iniConfig = iniConfig;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ServiceInfo> getServiceInfoList() {
            return this.serviceInfoList;
        }

        public void setServiceInfoList(List<ServiceInfo> serviceInfoList) {
            this.serviceInfoList = serviceInfoList;
        }

        static class ServiceInfo {
            private String serviceName;
            private int type;

            ServiceInfo() {
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public void setServiceName(String serviceName) {
                this.serviceName = serviceName;
            }

            public int getType() {
                return this.type;
            }

            public void setType(int type) {
                this.type = type;
            }

            public String toString() {
                return "ServiceInfo{serviceName='" + this.serviceName + '\'' + ", type=" + this.type + '}';
            }
        }
    }

    public static class Protocol {
        private long compatibilityVersion;
        private long minSupportedVersion;
        private long maxSupportedVersion;

        public long getCompatibilityVersion() {
            return this.compatibilityVersion;
        }

        public void setCompatibilityVersion(long compatibilityVersion) {
            this.compatibilityVersion = compatibilityVersion;
        }

        public long getMinSupportedVersion() {
            return this.minSupportedVersion;
        }

        public void setMinSupportedVersion(long minSupportedVersion) {
            this.minSupportedVersion = minSupportedVersion;
        }

        public long getMaxSupportedVersion() {
            return this.maxSupportedVersion;
        }

        public void setMaxSupportedVersion(long maxSupportedVersion) {
            this.maxSupportedVersion = maxSupportedVersion;
        }

        public String toString() {
            return "Protocol{compatibilityVersion=" + this.compatibilityVersion + ", minSupportedVersion=" + this.minSupportedVersion + ", maxSupportedVersion=" + this.maxSupportedVersion + '}';
        }
    }
}

