/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client.protocol.model;

import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.jni.utilities.keypair.KeyPairJniObj;
import org.fisco.bcos.sdk.jni.utilities.tx.TransactionBuilderJniObj;
import org.fisco.bcos.sdk.v3.client.exceptions.ClientException;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.model.MerkleProofUnit;
import org.fisco.bcos.sdk.v3.utils.AddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTransactionResponse {
    private static final Logger logger = LoggerFactory.getLogger(JsonTransactionResponse.class);
    private Integer version;
    private String hash;
    private String nonce;
    private long blockLimit;
    private String to;
    private String from;
    private String abi = "";
    private String input;
    private String chainID;
    private String groupID;
    private String signature;
    private long importTime;
    private List<MerkleProofUnit> transactionProof;

    public String getAbi() {
        return this.abi;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public List<MerkleProofUnit> getTransactionProof() {
        return this.transactionProof;
    }

    public void setTransactionProof(List<MerkleProofUnit> transactionProof) {
        this.transactionProof = transactionProof;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getTo() {
        return AddressUtils.addHexPrefixToAddress(this.to);
    }

    public void setTo(String to) {
        this.to = to;
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public void setBlockLimit(long blockLimit) {
        this.blockLimit = blockLimit;
    }

    public String getChainID() {
        return this.chainID;
    }

    public void setChainID(String chainId) {
        this.chainID = chainId;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String calculateHash(CryptoSuite cryptoSuite) throws ClientException {
        try {
            long transactionData = TransactionBuilderJniObj.createTransactionData((String)this.groupID, (String)this.chainID, (String)this.to, (String)this.input, (String)this.abi, (long)this.blockLimit);
            long jniKeyPair = cryptoSuite.getCryptoKeyPair().getJniKeyPair();
            int jniKeyPairCryptoType = KeyPairJniObj.getJniKeyPairCryptoType((long)jniKeyPair);
            return TransactionBuilderJniObj.calcTransactionDataHash((int)jniKeyPairCryptoType, (long)transactionData);
        }
        catch (Exception e) {
            logger.warn("calculate hash for the transaction failed, version: {}, transactionHash: {}, error info: {}", new Object[]{this.version, this.hash, e});
            throw new ClientException("calculate hash for transaction " + this.hash + " failed for " + e.getMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonTransactionResponse that = (JsonTransactionResponse)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.from, that.from) && Objects.equals(this.hash, that.hash) && Objects.equals(this.transactionProof, that.transactionProof) && Objects.equals(this.input, that.input) && Objects.equals(this.nonce, that.nonce) && Objects.equals(this.to, that.to) && Objects.equals(this.abi, that.abi) && Objects.equals(this.blockLimit, that.blockLimit) && Objects.equals(this.chainID, that.chainID) && Objects.equals(this.groupID, that.groupID) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.from, this.hash, this.input, this.nonce, this.to, this.abi, this.blockLimit, this.chainID, this.groupID, this.signature);
    }

    public String toString() {
        return "{version='" + this.version + '\'' + ", from='" + this.from + '\'' + ", hash='" + this.hash + '\'' + ", input='" + this.input + '\'' + ", nonce='" + this.nonce + '\'' + ", to='" + this.getTo() + '\'' + ", abi='" + this.abi + '\'' + ", blockLimit='" + this.blockLimit + '\'' + ", chainId='" + this.chainID + '\'' + ", groupID='" + this.groupID + '\'' + ", transactionProof='" + this.transactionProof + '\'' + ", signature=" + this.signature + '}';
    }

    public long getImportTime() {
        return this.importTime;
    }

    public void setImportTime(long importTime) {
        this.importTime = importTime;
    }
}

