/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client.protocol.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.fisco.bcos.sdk.v3.client.protocol.model.GroupNodeIniInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupNodeIniConfig {
    private static final Logger logger = LoggerFactory.getLogger(GroupNodeIniConfig.class);
    private Chain chain;
    private Executor executor;

    public static GroupNodeIniConfig newIniConfig(GroupNodeIniInfo groupIniConfig) {
        try {
            Chain chain = new Chain();
            chain.setChainID(groupIniConfig.getChainID());
            chain.setGroupID(groupIniConfig.getGroupID());
            chain.setSmCrypto(groupIniConfig.getSmCryptoType());
            Executor executor = new Executor();
            executor.setWasm(groupIniConfig.getWasm());
            executor.setAuthCheck(groupIniConfig.getAuthCheck());
            executor.setSerialExecute(groupIniConfig.getIsSerialExecute());
            GroupNodeIniConfig groupNodeIniConfig = new GroupNodeIniConfig();
            groupNodeIniConfig.setChain(chain);
            groupNodeIniConfig.setExecutor(executor);
            return groupNodeIniConfig;
        }
        catch (Exception e) {
            logger.error("Failed to resolve the node configuration, e:", (Throwable)e);
            throw new RuntimeException("Failed to resolve the node ini config, error: " + e.getCause());
        }
    }

    public Chain getChain() {
        return this.chain;
    }

    public void setChain(Chain chain) {
        this.chain = chain;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public static class Chain {
        private boolean smCrypto;
        private String groupID;
        private String chainID;

        public boolean isSmCrypto() {
            return this.smCrypto;
        }

        public void setSmCrypto(boolean smCrypto) {
            this.smCrypto = smCrypto;
        }

        public String getGroupID() {
            return this.groupID;
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        public String getChainID() {
            return this.chainID;
        }

        public void setChainID(String chainID) {
            this.chainID = chainID;
        }

        public String toString() {
            return "Chain{smCrypto=" + this.smCrypto + ", groupID='" + this.groupID + '\'' + ", chainID='" + this.chainID + '\'' + '}';
        }
    }

    public static class Executor {
        private boolean isWasm;
        private boolean isAuthCheck;
        private boolean isSerialExecute;

        public boolean isWasm() {
            return this.isWasm;
        }

        public void setWasm(boolean wasm) {
            this.isWasm = wasm;
        }

        public boolean isAuthCheck() {
            return this.isAuthCheck;
        }

        public void setAuthCheck(boolean authCheck) {
            this.isAuthCheck = authCheck;
        }

        public boolean isSerialExecute() {
            return this.isSerialExecute;
        }

        public void setSerialExecute(boolean serialExecute) {
            this.isSerialExecute = serialExecute;
        }

        public String toString() {
            return "Executor{isWasm=" + this.isWasm + ", isAuthCheck=" + this.isAuthCheck + ", isSerialExecute=" + this.isSerialExecute + '}';
        }
    }
}

