/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.client;

import java.math.BigInteger;
import org.fisco.bcos.sdk.jni.BcosSDKJniObj;
import org.fisco.bcos.sdk.jni.common.JniConfig;
import org.fisco.bcos.sdk.v3.client.ClientImpl;
import org.fisco.bcos.sdk.v3.client.RespCallback;
import org.fisco.bcos.sdk.v3.client.protocol.request.Transaction;
import org.fisco.bcos.sdk.v3.client.protocol.response.Abi;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosBlock;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosGroupInfo;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosGroupInfoList;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosGroupList;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosGroupNodeInfo;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosTransaction;
import org.fisco.bcos.sdk.v3.client.protocol.response.BcosTransactionReceipt;
import org.fisco.bcos.sdk.v3.client.protocol.response.BlockHash;
import org.fisco.bcos.sdk.v3.client.protocol.response.BlockNumber;
import org.fisco.bcos.sdk.v3.client.protocol.response.Call;
import org.fisco.bcos.sdk.v3.client.protocol.response.Code;
import org.fisco.bcos.sdk.v3.client.protocol.response.ConsensusStatus;
import org.fisco.bcos.sdk.v3.client.protocol.response.GroupPeers;
import org.fisco.bcos.sdk.v3.client.protocol.response.ObserverList;
import org.fisco.bcos.sdk.v3.client.protocol.response.PbftView;
import org.fisco.bcos.sdk.v3.client.protocol.response.Peers;
import org.fisco.bcos.sdk.v3.client.protocol.response.PendingTxSize;
import org.fisco.bcos.sdk.v3.client.protocol.response.SealerList;
import org.fisco.bcos.sdk.v3.client.protocol.response.SyncStatus;
import org.fisco.bcos.sdk.v3.client.protocol.response.SystemConfig;
import org.fisco.bcos.sdk.v3.client.protocol.response.TotalTransactionCount;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.fisco.bcos.sdk.v3.crypto.CryptoSuite;
import org.fisco.bcos.sdk.v3.model.callback.TransactionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Client {
    public static final Logger logger = LoggerFactory.getLogger(Client.class);

    public static Client build(ConfigOption configOption) {
        logger.info("build, configOption: {}", (Object)configOption);
        return Client.build(null, configOption);
    }

    public static Client build(String groupId, ConfigOption configOption) {
        logger.info("build, groupID: {}, configOption: {}", (Object)groupId, (Object)configOption);
        long nativePointer = BcosSDKJniObj.create((JniConfig)configOption.getJniConfig());
        return Client.build(groupId, configOption, nativePointer);
    }

    public static Client build(String groupId, ConfigOption configOption, long nativePointer) {
        logger.info("build, groupID: {}, configOption: {}, nativePointer: {}", new Object[]{groupId, configOption, nativePointer});
        return new ClientImpl(groupId, configOption, nativePointer);
    }

    public long getNativePointer();

    public CryptoSuite getCryptoSuite();

    public Integer getCryptoType();

    public Boolean isWASM();

    public Boolean isAuthCheck();

    public Boolean isSerialExecute();

    public String getGroup();

    public String getChainId();

    public ConfigOption getConfigOption();

    public BcosTransactionReceipt sendTransaction(String var1, boolean var2);

    public BcosTransactionReceipt sendTransaction(String var1, String var2, boolean var3);

    public void sendTransactionAsync(String var1, boolean var2, TransactionCallback var3);

    public void sendTransactionAsync(String var1, String var2, boolean var3, TransactionCallback var4);

    public Call call(Transaction var1);

    public Call call(String var1, Transaction var2);

    public void callAsync(Transaction var1, RespCallback<Call> var2);

    public void callAsync(String var1, Transaction var2, RespCallback<Call> var3);

    public BlockNumber getBlockNumber();

    public BlockNumber getBlockNumber(String var1);

    public void getBlockNumberAsync(RespCallback<BlockNumber> var1);

    public void getBlockNumberAsync(String var1, RespCallback<BlockNumber> var2);

    public Code getCode(String var1);

    public Code getCode(String var1, String var2);

    public void getCodeAsync(String var1, RespCallback<Code> var2);

    public void getCodeAsync(String var1, String var2, RespCallback<Code> var3);

    public Abi getABI(String var1);

    public Abi getABI(String var1, String var2);

    public void getABIAsync(String var1, RespCallback<Abi> var2);

    public void getABIAsync(String var1, String var2, RespCallback<Abi> var3);

    public TotalTransactionCount getTotalTransactionCount();

    public TotalTransactionCount getTotalTransactionCount(String var1);

    public void getTotalTransactionCountAsync(RespCallback<TotalTransactionCount> var1);

    public void getTotalTransactionCountAsync(String var1, RespCallback<TotalTransactionCount> var2);

    public BcosBlock getBlockByHash(String var1, boolean var2, boolean var3);

    public BcosBlock getBlockByHash(String var1, String var2, boolean var3, boolean var4);

    public void getBlockByHashAsync(String var1, boolean var2, boolean var3, RespCallback<BcosBlock> var4);

    public void getBlockByHashAsync(String var1, String var2, boolean var3, boolean var4, RespCallback<BcosBlock> var5);

    public BcosBlock getBlockByNumber(BigInteger var1, boolean var2, boolean var3);

    public BcosBlock getBlockByNumber(String var1, BigInteger var2, boolean var3, boolean var4);

    public void getBlockByNumberAsync(BigInteger var1, boolean var2, boolean var3, RespCallback<BcosBlock> var4);

    public void getBlockByNumberAsync(String var1, BigInteger var2, boolean var3, boolean var4, RespCallback<BcosBlock> var5);

    public BlockHash getBlockHashByNumber(BigInteger var1);

    public void getBlockHashByNumberAsync(BigInteger var1, RespCallback<BlockHash> var2);

    public BlockHash getBlockHashByNumber(String var1, BigInteger var2);

    public void getBlockHashByNumberAsync(String var1, BigInteger var2, RespCallback<BlockHash> var3);

    public BcosTransaction getTransaction(String var1, Boolean var2);

    public BcosTransaction getTransaction(String var1, String var2, Boolean var3);

    public void getTransactionAsync(String var1, Boolean var2, RespCallback<BcosTransaction> var3);

    public void getTransactionAsync(String var1, String var2, Boolean var3, RespCallback<BcosTransaction> var4);

    public BcosTransactionReceipt getTransactionReceipt(String var1, Boolean var2);

    public BcosTransactionReceipt getTransactionReceipt(String var1, String var2, Boolean var3);

    public void getTransactionReceiptAsync(String var1, Boolean var2, RespCallback<BcosTransactionReceipt> var3);

    public void getTransactionReceiptAsync(String var1, String var2, Boolean var3, RespCallback<BcosTransactionReceipt> var4);

    public PendingTxSize getPendingTxSize(String var1);

    public void getPendingTxSizeAsync(String var1, RespCallback<PendingTxSize> var2);

    public PendingTxSize getPendingTxSize();

    public void getPendingTxSizeAsync(RespCallback<PendingTxSize> var1);

    public BigInteger getBlockLimit();

    public Peers getPeers();

    public GroupPeers getGroupPeers();

    public void getGroupPeersAsync(RespCallback<GroupPeers> var1);

    public void getPeersAsync(RespCallback<Peers> var1);

    public ObserverList getObserverList();

    public ObserverList getObserverList(String var1);

    public void getObserverList(RespCallback<ObserverList> var1);

    public void getObserverList(String var1, RespCallback<ObserverList> var2);

    public SealerList getSealerList();

    public SealerList getSealerList(String var1);

    public void getSealerListAsync(RespCallback<SealerList> var1);

    public void getSealerListAsync(String var1, RespCallback<SealerList> var2);

    public PbftView getPbftView();

    public PbftView getPbftView(String var1);

    public void getPbftViewAsync(RespCallback<PbftView> var1);

    public void getPbftViewAsync(String var1, RespCallback<PbftView> var2);

    public SystemConfig getSystemConfigByKey(String var1);

    public SystemConfig getSystemConfigByKey(String var1, String var2);

    public void getSystemConfigByKeyAsync(String var1, RespCallback<SystemConfig> var2);

    public void getSystemConfigByKeyAsync(String var1, String var2, RespCallback<SystemConfig> var3);

    public SyncStatus getSyncStatus(String var1);

    public void getSyncStatusAsync(String var1, RespCallback<SyncStatus> var2);

    public SyncStatus getSyncStatus();

    public void getSyncStatusAsync(RespCallback<SyncStatus> var1);

    public void getConsensusStatusAsync(String var1, RespCallback<ConsensusStatus> var2);

    public void getConsensusStatusAsync(RespCallback<ConsensusStatus> var1);

    public ConsensusStatus getConsensusStatus(String var1);

    public ConsensusStatus getConsensusStatus();

    public BcosGroupList getGroupList();

    public void getGroupListAsync(RespCallback<BcosGroupList> var1);

    public BcosGroupInfo getGroupInfo();

    public void getGroupInfoAsync(RespCallback<BcosGroupInfo> var1);

    public BcosGroupInfoList getGroupInfoList();

    public void getGroupInfoListAsync(RespCallback<BcosGroupInfoList> var1);

    public BcosGroupNodeInfo getGroupNodeInfo(String var1);

    public void getGroupNodeInfoAsync(String var1, RespCallback<BcosGroupNodeInfo> var2);

    public void start();

    public void stop();

    public void destroy();
}

