/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.amop;

import java.util.HashSet;
import java.util.Set;
import org.fisco.bcos.sdk.jni.BcosSDKJniObj;
import org.fisco.bcos.sdk.jni.amop.AmopJniObj;
import org.fisco.bcos.sdk.jni.amop.AmopRequestCallback;
import org.fisco.bcos.sdk.jni.amop.AmopResponseCallback;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.v3.amop.Amop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmopImp
implements Amop {
    private static final Logger logger = LoggerFactory.getLogger(AmopImp.class);
    private AmopJniObj amopJni;

    public AmopImp(long nativePointer) throws JniException {
        this.amopJni = AmopJniObj.build((long)nativePointer);
        logger.info("newAmop, nativePointer: {}", (Object)nativePointer);
        this.start();
    }

    @Override
    public void subscribeTopic(Set<String> topics) {
        this.amopJni.subscribeTopic(topics);
    }

    @Override
    public void subscribeTopic(String topicName, AmopRequestCallback callback) {
        this.amopJni.subscribeTopic(topicName, callback);
    }

    @Override
    public void unsubscribeTopic(String topicName) {
        HashSet<String> topics = new HashSet<String>();
        topics.add(topicName);
        this.amopJni.unsubscribeTopic(topics);
    }

    @Override
    public void sendAmopMsg(String topic, byte[] content, int timeout, AmopResponseCallback callback) {
        this.amopJni.sendAmopMsg(topic, content, timeout, callback);
    }

    @Override
    public void sendResponse(String endpoint, String seq, byte[] content) {
        this.amopJni.sendResponse(endpoint, seq, content);
    }

    @Override
    public void broadcastAmopMsg(String topic, byte[] content) {
        this.amopJni.broadcastAmopMsg(topic, content);
    }

    @Override
    public Set<String> getSubTopics() {
        return this.amopJni.getSubTopics();
    }

    @Override
    public void setCallback(AmopRequestCallback cb) {
        this.amopJni.setCallback(cb);
    }

    @Override
    public void start() {
        if (this.amopJni != null) {
            this.amopJni.start();
        }
    }

    @Override
    public void stop() {
        if (this.amopJni != null) {
            this.amopJni.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.amopJni != null) {
            BcosSDKJniObj.destroy((long)this.amopJni.getNativePointer());
            this.amopJni = null;
        }
    }
}

