/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3.amop;

import java.util.Set;
import org.fisco.bcos.sdk.jni.BcosSDKJniObj;
import org.fisco.bcos.sdk.jni.amop.AmopRequestCallback;
import org.fisco.bcos.sdk.jni.amop.AmopResponseCallback;
import org.fisco.bcos.sdk.jni.common.JniConfig;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.v3.amop.AmopImp;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Amop {
    public static final Logger logger = LoggerFactory.getLogger(Amop.class);

    public static Amop build(ConfigOption configOption) throws JniException {
        long nativePointer = BcosSDKJniObj.create((JniConfig)configOption.getJniConfig());
        logger.info("build AMOP, configOption: {}", (Object)configOption);
        return new AmopImp(nativePointer);
    }

    public static Amop build(long nativePointer) throws JniException {
        return new AmopImp(nativePointer);
    }

    public void subscribeTopic(Set<String> var1);

    public void subscribeTopic(String var1, AmopRequestCallback var2);

    public void unsubscribeTopic(String var1);

    public void sendAmopMsg(String var1, byte[] var2, int var3, AmopResponseCallback var4);

    public void sendResponse(String var1, String var2, byte[] var3);

    public void broadcastAmopMsg(String var1, byte[] var2);

    public Set<String> getSubTopics();

    public void setCallback(AmopRequestCallback var1);

    public void start();

    public void stop();

    public void destroy();
}

