/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.v3;

import org.fisco.bcos.sdk.jni.BcosSDKJniObj;
import org.fisco.bcos.sdk.jni.BlockNotifier;
import org.fisco.bcos.sdk.jni.common.JniConfig;
import org.fisco.bcos.sdk.v3.BcosSDKException;
import org.fisco.bcos.sdk.v3.amop.Amop;
import org.fisco.bcos.sdk.v3.client.Client;
import org.fisco.bcos.sdk.v3.config.Config;
import org.fisco.bcos.sdk.v3.config.ConfigOption;
import org.fisco.bcos.sdk.v3.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.v3.eventsub.EventSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcosSDK {
    private static final Logger logger = LoggerFactory.getLogger(BcosSDK.class);
    private final ConfigOption config;
    private final BcosSDKJniObj bcosSDKJniObj;

    public ConfigOption getConfig() {
        return this.config;
    }

    public static BcosSDK build(String tomlConfigFilePath) throws BcosSDKException {
        try {
            ConfigOption configOption = Config.load(tomlConfigFilePath);
            logger.info("create BcosSDK, configPath: {}", (Object)tomlConfigFilePath);
            return new BcosSDK(configOption);
        }
        catch (ConfigException e) {
            throw new BcosSDKException("create BcosSDK failed, error info: " + e.getMessage(), e);
        }
    }

    public BcosSDK(ConfigOption configOption) throws BcosSDKException {
        try {
            this.config = configOption;
            this.bcosSDKJniObj = BcosSDKJniObj.build((JniConfig)this.config.getJniConfig());
        }
        catch (Exception e) {
            throw new BcosSDKException("create BcosSDK failed, error: " + e.getMessage(), e);
        }
    }

    public void registerBlockNotifier(String groupID, BlockNotifier blockNotifier) {
        this.bcosSDKJniObj.registerBlockNotifier(groupID, blockNotifier);
    }

    public Client getClient(String groupId) throws BcosSDKException {
        try {
            return Client.build(groupId, this.config, this.bcosSDKJniObj.getNativePointer());
        }
        catch (Exception e) {
            logger.warn("create client for failed, error: ", (Throwable)e);
            throw new BcosSDKException("get Client failed, e: " + e.getMessage(), e);
        }
    }

    public Client getClient() throws BcosSDKException {
        try {
            String groupId = this.config.getNetworkConfig().getDefaultGroup();
            if (groupId == null || groupId.isEmpty()) {
                throw new BcosSDKException("The default group is not set, please set it in config.toml: defaultGroup field");
            }
            return Client.build(this.config.getNetworkConfig().getDefaultGroup(), this.config, this.bcosSDKJniObj.getNativePointer());
        }
        catch (Exception e) {
            logger.warn("create client for failed, error: ", (Throwable)e);
            throw new BcosSDKException("get Client failed, e: " + e.getMessage(), e);
        }
    }

    public Amop getAmop() throws BcosSDKException {
        try {
            return Amop.build(this.config);
        }
        catch (Exception e) {
            logger.error("create amop for failed, error: ", (Throwable)e);
            throw new BcosSDKException("get amop failed, e: " + e.getMessage());
        }
    }

    public EventSubscribe getEventSubscribe(String groupId) throws BcosSDKException {
        try {
            return EventSubscribe.build(groupId, this.config);
        }
        catch (Exception e) {
            logger.warn("create event sub for failed, error: ", (Throwable)e);
            throw new BcosSDKException("get event sub failed, e: " + e.getMessage());
        }
    }

    public void stopAll() {
    }
}

