/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.jni.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JniLibLoader {
    private static final Logger logger;
    public static final String LINUX = "linux";
    public static final String MAC = "mac";
    public static final String WIN = "win";
    public static final String NATIVE_RESOURCE_LIB_NAME = "bcos-sdk-jni";
    public static final String NATIVE_RESOURCE_HOME = "/META-INF/native";
    public static final String NATIVE_WIN_DEPS_DIR = "/META-INF/native/win/";
    public static final String WIN_DEPS_FILE_LIST = "file.list";
    public static final String OS_NAME;
    public static final String ARCH_NAME;
    private static File WORKDIR;

    public static String getArch() {
        String archName = System.getProperty("os.arch", "");
        if (archName.contains("aarch64") || archName.contains("arm64")) {
            return "arm";
        }
        return "";
    }

    public static String getLibName(String baseName) {
        String osName = OS_NAME;
        String archName = ARCH_NAME;
        logger.debug("osName: {}, archName: {}", (Object)osName, (Object)archName);
        if (osName.contains(WIN)) {
            return baseName + ".dll";
        }
        if (osName.contains(LINUX)) {
            String arch = JniLibLoader.getArch();
            if ("arm".equals(arch)) {
                return "lib" + baseName + "-aarch64.so";
            }
            return "lib" + baseName + ".so";
        }
        if (osName.contains(MAC)) {
            String arch = JniLibLoader.getArch();
            if ("arm".equals(arch)) {
                return "lib" + baseName + "-aarch64.dylib";
            }
            return "lib" + baseName + ".dylib";
        }
        throw new RuntimeException("unrecognized OS: " + osName);
    }

    public static String getOs() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains(WIN)) {
            return WIN;
        }
        if (osName.contains(LINUX)) {
            return LINUX;
        }
        if (osName.contains(MAC)) {
            return MAC;
        }
        throw new RuntimeException("unrecognized OS: " + osName);
    }

    public static void loadJniLibrary() {
        String libPath = null;
        boolean loadLibFromFsOk = false;
        try {
            libPath = System.getProperty("org.fisco.bcos.jni.library.path");
            if (libPath != null) {
                logger.info("try to load library -Dorg.fisco.bcos.jni.library.path, libPath: {}", (Object)libPath);
                JniLibLoader.loadLibraryFromFs(libPath, NATIVE_RESOURCE_LIB_NAME, new File(libPath).isAbsolute());
                loadLibFromFsOk = true;
            }
        }
        catch (Exception e0) {
            logger.error("unable to load library from fs, libDir: {}, e: ", (Object)libPath, (Object)e0);
        }
        if (!loadLibFromFsOk) {
            try {
                logger.info("try to load library from jar");
                if (Objects.equals(JniLibLoader.getOs(), WIN)) {
                    JniLibLoader.loadWinDepsLibraryFromJar();
                }
                JniLibLoader.loadLibraryFromJar(NATIVE_RESOURCE_LIB_NAME);
            }
            catch (Exception e1) {
                logger.error("unable to load library from fs, e: ", (Throwable)e1);
                throw new UnsatisfiedLinkError(e1.toString());
            }
        }
    }

    public static void loadLibrary(String lib, boolean absolute) {
        if (absolute) {
            System.load(lib);
        } else {
            System.loadLibrary(lib);
        }
    }

    public static void addLibraryDir(String libraryPath) throws NoSuchFieldException, IllegalAccessException {
        Field userPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        userPathsField.setAccessible(true);
        String[] paths = (String[])userPathsField.get(null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            if (libraryPath.equals(paths[i])) continue;
            sb.append(paths[i]).append(File.pathSeparator);
        }
        sb.append(libraryPath);
        System.setProperty("java.library.path", sb.toString());
        logger.info("modify, java.library.path: " + sb.toString());
        Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
        sysPathsField.setAccessible(true);
        sysPathsField.set(null, null);
    }

    public static void loadLibraryFromFs(String dir, String libName, boolean absolute) {
        String resource = dir + "/" + JniLibLoader.getLibName(libName);
        JniLibLoader.loadLibrary(resource, absolute);
    }

    public static void loadLibraryFromJar(String baseName) throws IOException, NoSuchFieldException, IllegalAccessException {
        String libName = JniLibLoader.getLibName(baseName);
        File tempDir = new File(WORKDIR, String.valueOf(System.nanoTime()));
        tempDir.mkdirs();
        File tempFile = new File(tempDir, libName);
        logger.info("tempDir: {}, tempFile: {}", (Object)tempDir, (Object)tempFile);
        String resource = "/META-INF/native/" + libName;
        try (InputStream is = JniLibLoader.class.getResourceAsStream(resource);){
            Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                tempFile.delete();
            }
            catch (Exception e0) {
                logger.debug("delete temp file error, e: ", (Throwable)e0);
            }
            logger.error("copy dynamic lib from jar failed, resource: {}, e: ", (Object)resource, (Object)e);
            throw e;
        }
        catch (NullPointerException e) {
            throw new FileNotFoundException("Cannot found " + resource + " inside the JAR.");
        }
        try {
            JniLibLoader.loadLibrary(tempFile.getAbsolutePath(), true);
        }
        catch (Exception e) {
            logger.error("loadLibrary error, resource: {}, e: ", (Object)resource, (Object)e);
            throw e;
        }
        finally {
            try {
                tempFile.delete();
                tempDir.delete();
                logger.debug("remove temp dir and temp file, dir: {}, file: {}", (Object)tempDir, (Object)tempFile);
            }
            catch (Exception exception) {}
        }
    }

    public static void loadWinDepsLibraryFromJar() throws IOException, NoSuchFieldException {
        block51: {
            File tempDir = new File(WORKDIR, String.valueOf(System.nanoTime()));
            tempDir.mkdirs();
            try (InputStream is = JniLibLoader.class.getResourceAsStream("/META-INF/native/win/file.list");){
                if (is == null) {
                    throw new FileNotFoundException("Cannot found file.list inside the JAR.");
                }
                Scanner scanner = new Scanner(is);
                Throwable throwable = null;
                block40: while (true) {
                    try {
                        while (scanner.hasNext()) {
                            String lib = scanner.next();
                            File targetFile = new File(tempDir, lib);
                            logger.info("loadWinDepsLibraryFromJar tempDir: {}, targetFile: {}", (Object)tempDir, (Object)targetFile);
                            try {
                                InputStream fis = JniLibLoader.class.getResourceAsStream(NATIVE_WIN_DEPS_DIR + lib);
                                Throwable throwable2 = null;
                                try {
                                    if (fis == null) {
                                        throw new FileNotFoundException("Cannot found " + lib + " inside the JAR.");
                                    }
                                    Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    JniLibLoader.loadLibrary(targetFile.getAbsolutePath(), true);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (fis == null) continue block40;
                                    if (throwable2 != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block40;
                                    }
                                    fis.close();
                                }
                            }
                            catch (IOException e) {
                                targetFile.delete();
                            }
                            catch (Exception e) {
                                logger.error("loadLibrary error, resource: {}, e: ", (Object)targetFile.getAbsolutePath(), (Object)e);
                                throw e;
                            }
                            finally {
                                try {
                                    targetFile.delete();
                                    tempDir.delete();
                                    logger.debug("remove temp dir and temp file, {}", (Object)targetFile);
                                    continue block40;
                                }
                                catch (Exception e) {}
                                continue;
                                continue block40;
                            }
                        }
                        break block51;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    break;
                }
                finally {
                    if (scanner != null) {
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            scanner.close();
                        }
                    }
                }
            }
        }
    }

    static {
        File f;
        logger = LoggerFactory.getLogger(JniLibLoader.class);
        OS_NAME = JniLibLoader.getOs();
        ARCH_NAME = JniLibLoader.getArch();
        String workdir = System.getProperty("org.fisco.bcos.workdir");
        if (workdir != null) {
            try {
                f = new File(workdir);
                f.mkdirs();
                WORKDIR = f;
                logger.info("initialize workdir, -Dorg.fisco.bcos.workdir: {}", (Object)WORKDIR);
            }
            catch (Exception e) {
                logger.debug("initialize workdir, cannot mkdir workdir: {}, e: ", (Object)workdir, (Object)e);
                workdir = null;
            }
        }
        if (workdir == null) {
            workdir = System.getProperty("java.io.tmpdir");
            f = new File(workdir);
            f.mkdirs();
            WORKDIR = f;
            logger.info("initialize workdir, -Djava.io.tmpdirs: {}", (Object)WORKDIR);
        }
    }
}

