/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.jni;

import org.fisco.bcos.sdk.jni.BlockNotifier;
import org.fisco.bcos.sdk.jni.common.JniConfig;
import org.fisco.bcos.sdk.jni.common.JniException;
import org.fisco.bcos.sdk.jni.common.JniLibLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcosSDKJniObj {
    private static final Logger logger = LoggerFactory.getLogger(BcosSDKJniObj.class);
    private long nativePointer = 0L;

    protected BcosSDKJniObj() {
    }

    public static BcosSDKJniObj build(JniConfig jniConfig) throws JniException {
        long nativePointer = BcosSDKJniObj.create(jniConfig);
        BcosSDKJniObj bcosSDKJniObj = new BcosSDKJniObj();
        bcosSDKJniObj.setNativePointer(nativePointer);
        logger.info("newNativePointer, nativePointer: {}, jniConfig: {}", (Object)nativePointer, (Object)jniConfig);
        return bcosSDKJniObj;
    }

    public static void destroy(long nativePointer) {
        if (nativePointer != 0L) {
            BcosSDKJniObj bcosSDKJniObj = new BcosSDKJniObj();
            bcosSDKJniObj.setNativePointer(nativePointer);
            bcosSDKJniObj.destroy();
        }
    }

    public long getNativePointer() {
        return this.nativePointer;
    }

    private void setNativePointer(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    public static int localProtocolInfo(long nativePointer) {
        BcosSDKJniObj bcosSDKJniObj = new BcosSDKJniObj();
        bcosSDKJniObj.setNativePointer(nativePointer);
        return bcosSDKJniObj.localProtocolInfo();
    }

    public static int negotiatedProtocolInfo(long nativePointer) {
        BcosSDKJniObj bcosSDKJniObj = new BcosSDKJniObj();
        bcosSDKJniObj.setNativePointer(nativePointer);
        return bcosSDKJniObj.negotiatedProtocolInfo();
    }

    public static native long create(JniConfig var0);

    public native void start();

    public native void stop();

    public native void destroy();

    public native int localProtocolInfo();

    public native int negotiatedProtocolInfo();

    public native void registerBlockNotifier(String var1, BlockNotifier var2);

    static {
        JniLibLoader.loadJniLibrary();
    }
}

