/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.util.List;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;

public class RowNumberQueryRewriter
extends DefaultQueryRewriter {
    public RowNumberQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    protected String getRowNumberSql(Query query, Integer maxRows, Integer firstRow) {
        Query innerQuery = query.clone();
        innerQuery.setFirstRow(null);
        innerQuery.setMaxRows(null);
        Query outerQuery = new Query();
        FromItem subQuerySelectItem = new FromItem(innerQuery).setAlias("metamodel_subquery");
        outerQuery.from(new FromItem[]{subQuerySelectItem});
        List innerSelectItems = innerQuery.getSelectClause().getItems();
        for (SelectItem selectItem : innerSelectItems) {
            outerQuery.select(new SelectItem[]{new SelectItem(selectItem, subQuerySelectItem)});
        }
        String rewrittenOrderByClause = this.rewriteOrderByClause(innerQuery, innerQuery.getOrderByClause());
        String rowOver = "ROW_NUMBER() OVER(" + rewrittenOrderByClause + ")";
        innerQuery.select(new SelectItem[]{new SelectItem(rowOver, "metamodel_row_number")});
        innerQuery.getOrderByClause().removeItems();
        String baseQueryString = this.rewriteQuery(outerQuery);
        if (maxRows == null) {
            return baseQueryString + " WHERE metamodel_row_number > " + (firstRow - 1);
        }
        return baseQueryString + " WHERE metamodel_row_number BETWEEN " + firstRow + " AND " + (firstRow - 1 + maxRows);
    }
}

