/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.Query;

public abstract class OffsetFetchQueryRewriter
extends DefaultQueryRewriter {
    private final String _databaseProductName;
    private final int _databaseSupportedVersion;
    private final boolean _fetchNeedsOffsetAndOrderBy;

    public OffsetFetchQueryRewriter(JdbcDataContext dataContext, int minSupportedVersion, boolean fetchNeedsOrderBy) {
        super(dataContext);
        this._databaseProductName = dataContext.getDatabaseProductName();
        this._databaseSupportedVersion = minSupportedVersion;
        this._fetchNeedsOffsetAndOrderBy = fetchNeedsOrderBy;
    }

    @Override
    public boolean isFirstRowSupported(Query query) {
        return this.isSupportedVersion(this._databaseProductName, this._databaseSupportedVersion) && !query.getOrderByClause().isEmpty();
    }

    @Override
    public boolean isMaxRowsSupported() {
        return this.isSupportedVersion(this._databaseProductName, this._databaseSupportedVersion);
    }

    @Override
    public String rewriteQuery(Query query) {
        boolean hasOrderBy = !query.getOrderByClause().isEmpty();
        String queryString = super.rewriteQuery(query);
        if (this.isSupportedVersion(this._databaseProductName, this._databaseSupportedVersion) && (query.getMaxRows() != null || query.getFirstRow() != null)) {
            Integer maxRows = query.getMaxRows();
            Integer firstRow = query.getFirstRow();
            if (!this._fetchNeedsOffsetAndOrderBy || hasOrderBy) {
                if (firstRow != null) {
                    queryString = queryString + " OFFSET " + (firstRow - 1) + " ROWS";
                } else if (this._fetchNeedsOffsetAndOrderBy) {
                    return queryString;
                }
                if (maxRows != null) {
                    queryString = queryString.replaceAll(" TOP [0-9]+", "");
                    queryString = queryString + " FETCH NEXT " + maxRows + " ROWS ONLY";
                }
            }
        }
        return queryString;
    }
}

