/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.client;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import shadow.org.elasticsearch.xpack.sql.client.StringUtils;
import shadow.org.elasticsearch.xpack.sql.client.SuppressForbidden;
import shadow.org.elasticsearch.xpack.sql.proto.SqlVersion;

public class ClientVersion {
    public static final SqlVersion CURRENT;

    @SuppressForbidden(reason="java.util.jar.JarFile must be explicitly closed on Windows")
    static Manifest getManifest(URL url) throws IOException {
        String urlStr = url.toString();
        if (urlStr.endsWith(".jar") || urlStr.endsWith(".jar!/")) {
            JarURLConnection jarConn;
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            if (url.getProtocol().equals("jar") && (jarConn = (JarURLConnection)conn).getEntryName() == null) {
                try (JarFile jar = jarConn.getJarFile();){
                    Manifest manifest = jar.getManifest();
                    return manifest;
                }
            }
            try (JarInputStream jar = new JarInputStream(conn.getInputStream());){
                Manifest manifest = jar.getManifest();
                return manifest;
            }
        }
        return null;
    }

    static SqlVersion extractVersion(URL url) {
        Manifest manifest = null;
        try {
            manifest = ClientVersion.getManifest(url);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Detected an Elasticsearch JDBC jar but cannot retrieve its version", ex);
        }
        String version = manifest != null ? manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version") : null;
        return version != null ? SqlVersion.fromString(version) : new SqlVersion(0, 0, 0);
    }

    public static boolean isServerCompatible(SqlVersion server) {
        return SqlVersion.hasVersionCompatibility(server);
    }

    public static int jdbcMajorVersion() {
        return 4;
    }

    public static int jdbcMinorVersion() {
        return 2;
    }

    static {
        Enumeration<URL> res;
        String target = ClientVersion.class.getName().replace(".", "/").concat(".class");
        try {
            res = ClientVersion.class.getClassLoader().getResources(target);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot detect Elasticsearch JDBC jar; it typically indicates a deployment issue...");
        }
        if (res != null) {
            ArrayList<URL> urls = Collections.list(res);
            LinkedHashSet<String> normalized = new LinkedHashSet<String>();
            for (URL url : urls) {
                normalized.add(StringUtils.normalize(url.toString()));
            }
            int foundJars = 0;
            if (normalized.size() > 1) {
                StringBuilder sb = new StringBuilder("Multiple Elasticsearch JDBC versions detected in the classpath; please use only one\n");
                for (String s : normalized) {
                    if (!s.contains("jar:")) continue;
                    ++foundJars;
                    sb.append(s.replace("!/" + target, ""));
                    sb.append("\n");
                }
                if (foundJars > 1) {
                    throw new IllegalArgumentException(sb.toString());
                }
            }
        }
        URL url = SqlVersion.class.getProtectionDomain().getCodeSource().getLocation();
        CURRENT = ClientVersion.extractVersion(url);
    }
}

