/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xcontent.cbor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import shadow.fasterxml.jackson.core.JsonEncoding;
import shadow.fasterxml.jackson.core.JsonFactory;
import shadow.fasterxml.jackson.core.JsonGenerator;
import shadow.fasterxml.jackson.core.JsonParser;
import shadow.fasterxml.jackson.dataformat.cbor.CBORFactory;
import shadow.org.elasticsearch.xcontent.DeprecationHandler;
import shadow.org.elasticsearch.xcontent.NamedXContentRegistry;
import shadow.org.elasticsearch.xcontent.XContent;
import shadow.org.elasticsearch.xcontent.XContentBuilder;
import shadow.org.elasticsearch.xcontent.XContentGenerator;
import shadow.org.elasticsearch.xcontent.XContentParseException;
import shadow.org.elasticsearch.xcontent.XContentParser;
import shadow.org.elasticsearch.xcontent.XContentType;
import shadow.org.elasticsearch.xcontent.cbor.CborXContentGenerator;
import shadow.org.elasticsearch.xcontent.cbor.CborXContentParser;
import shadow.org.elasticsearch.xcontent.support.filtering.FilterPath;

public class CborXContent
implements XContent {
    static final CBORFactory cborFactory = new CBORFactory();
    public static final CborXContent cborXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(cborXContent);
    }

    private CborXContent() {
    }

    @Override
    public XContentType type() {
        return XContentType.CBOR;
    }

    @Override
    public byte streamSeparator() {
        throw new XContentParseException("cbor does not support stream parsing...");
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new CborXContentGenerator(cborFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(content));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is, FilterPath[] includes, FilterPath[] excludes) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(is), includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return this.createParser(xContentRegistry, deprecationHandler, data, 0, data.length);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(new ByteArrayInputStream(data, offset, length)));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(reader));
    }

    static {
        cborFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        cborFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        cborFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        cborXContent = new CborXContent();
    }
}

