/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.datafeed.ChunkingConfig;
import org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.elasticsearch.client.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class DatafeedUpdate
implements ToXContentObject {
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("datafeed_update", true, a -> new Builder((String)a[0]));
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final BytesReference query;
    private final BytesReference aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final Integer maxEmptySearches;

    private static BytesReference parseBytes(XContentParser parser) throws IOException {
        XContentBuilder contentBuilder = JsonXContent.contentBuilder();
        contentBuilder.generator().copyCurrentStructure(parser);
        return BytesReference.bytes((XContentBuilder)contentBuilder);
    }

    private DatafeedUpdate(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, BytesReference query, BytesReference aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig, DelayedDataCheckConfig delayedDataCheckConfig, Integer maxEmptySearches) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices;
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields;
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
        this.delayedDataCheckConfig = delayedDataCheckConfig;
        this.maxEmptySearches = maxEmptySearches;
    }

    public String getId() {
        return this.id;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.id);
        this.addOptionalField(builder, Job.ID, this.jobId);
        if (this.queryDelay != null) {
            builder.field(DatafeedConfig.QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        }
        if (this.frequency != null) {
            builder.field(DatafeedConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        this.addOptionalField(builder, DatafeedConfig.INDICES, this.indices);
        if (this.query != null) {
            builder.field(DatafeedConfig.QUERY.getPreferredName(), DatafeedUpdate.asMap(this.query));
        }
        if (this.aggregations != null) {
            builder.field(DatafeedConfig.AGGREGATIONS.getPreferredName(), DatafeedUpdate.asMap(this.aggregations));
        }
        if (this.scriptFields != null) {
            builder.startObject(DatafeedConfig.SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.delayedDataCheckConfig != null) {
            builder.field(DatafeedConfig.DELAYED_DATA_CHECK_CONFIG.getPreferredName(), (ToXContent)this.delayedDataCheckConfig);
        }
        this.addOptionalField(builder, DatafeedConfig.SCROLL_SIZE, this.scrollSize);
        this.addOptionalField(builder, DatafeedConfig.CHUNKING_CONFIG, this.chunkingConfig);
        this.addOptionalField(builder, DatafeedConfig.MAX_EMPTY_SEARCHES, this.maxEmptySearches);
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    public BytesReference getAggregations() {
        return this.aggregations;
    }

    public List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public DelayedDataCheckConfig getDelayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public Integer getMaxEmptySearches() {
        return this.maxEmptySearches;
    }

    private static Map<String, Object> asMap(BytesReference bytesReference) {
        return bytesReference == null ? null : (Map)XContentHelper.convertToMap((BytesReference)bytesReference, (boolean)true, (XContentType)XContentType.JSON).v2();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DatafeedUpdate that = (DatafeedUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(DatafeedUpdate.asMap(this.query), DatafeedUpdate.asMap(that.query)) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(DatafeedUpdate.asMap(this.aggregations), DatafeedUpdate.asMap(that.aggregations)) && Objects.equals(this.delayedDataCheckConfig, that.delayedDataCheckConfig) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig) && Objects.equals(this.maxEmptySearches, that.maxEmptySearches);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, DatafeedUpdate.asMap(this.query), this.scrollSize, DatafeedUpdate.asMap(this.aggregations), this.scriptFields, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches);
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DatafeedConfig.ID);
        PARSER.declareString(Builder::setJobId, Job.ID);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDEXES);
        PARSER.declareStringArray(Builder::setIndices, DatafeedConfig.INDICES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.QUERY_DELAY.getPreferredName())), DatafeedConfig.QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)DatafeedConfig.FREQUENCY.getPreferredName())), DatafeedConfig.FREQUENCY);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setQuery(x$0), DatafeedUpdate::parseBytes, DatafeedConfig.QUERY, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setAggregations(x$0), DatafeedUpdate::parseBytes, DatafeedConfig.AGGREGATIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
            }
            return parsedScriptFields;
        }, DatafeedConfig.SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, DatafeedConfig.SCROLL_SIZE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.PARSER, DatafeedConfig.CHUNKING_CONFIG);
        PARSER.declareObject(Builder::setDelayedDataCheckConfig, DelayedDataCheckConfig.PARSER, DatafeedConfig.DELAYED_DATA_CHECK_CONFIG);
        PARSER.declareInt(Builder::setMaxEmptySearches, DatafeedConfig.MAX_EMPTY_SEARCHES);
    }

    public static class Builder {
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices;
        private BytesReference query;
        private BytesReference aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize;
        private ChunkingConfig chunkingConfig;
        private DelayedDataCheckConfig delayedDataCheckConfig;
        private Integer maxEmptySearches;

        public Builder(String id) {
            this.id = Objects.requireNonNull(id, DatafeedConfig.ID.getPreferredName());
        }

        public Builder(DatafeedUpdate config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices;
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields;
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
            this.delayedDataCheckConfig = config.delayedDataCheckConfig;
            this.maxEmptySearches = config.maxEmptySearches;
        }

        @Deprecated
        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setIndices(List<String> indices) {
            this.indices = indices;
            return this;
        }

        public Builder setIndices(String ... indices) {
            return this.setIndices(Arrays.asList(indices));
        }

        public Builder setQueryDelay(TimeValue queryDelay) {
            this.queryDelay = queryDelay;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        private Builder setQuery(BytesReference query) {
            this.query = query;
            return this;
        }

        public Builder setQuery(String queryAsJson) {
            this.query = queryAsJson == null ? null : new BytesArray(queryAsJson);
            return this;
        }

        public Builder setQuery(QueryBuilder query) throws IOException {
            this.query = query == null ? null : Builder.xContentToBytes((ToXContentObject)query);
            return this;
        }

        private Builder setAggregations(BytesReference aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public Builder setAggregations(String aggsAsJson) {
            this.aggregations = aggsAsJson == null ? null : new BytesArray(aggsAsJson);
            return this;
        }

        public Builder setAggregations(AggregatorFactories.Builder aggregations) throws IOException {
            this.aggregations = aggregations == null ? null : Builder.xContentToBytes((ToXContentObject)aggregations);
            return this;
        }

        public Builder setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>(scriptFields);
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
            return this;
        }

        public Builder setScrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        public Builder setDelayedDataCheckConfig(DelayedDataCheckConfig delayedDataCheckConfig) {
            this.delayedDataCheckConfig = delayedDataCheckConfig;
            return this;
        }

        public Builder setMaxEmptySearches(int maxEmptySearches) {
            this.maxEmptySearches = maxEmptySearches;
            return this;
        }

        public DatafeedUpdate build() {
            return new DatafeedUpdate(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches);
        }

        private static BytesReference xContentToBytes(ToXContentObject object) throws IOException {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                object.toXContent(builder, ToXContentObject.EMPTY_PARAMS);
                BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
                return bytesReference;
            }
        }
    }
}

