/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.UtilDecompositons_CD64;
import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholderTran_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F QR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected Complex64F tau = new Complex64F();
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numCols, numRows);
        int maxLength = Math.max(numCols, numRows);
        if (this.QR == null) {
            this.QR = new CDenseMatrix64F(numCols, numRows);
            this.v = new double[maxLength * 2];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(numCols, numRows);
        }
        if (this.v.length < maxLength * 2) {
            this.v = new double[maxLength * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public CDenseMatrix64F getQR() {
        return this.QR;
    }

    public CDenseMatrix64F getQ(CDenseMatrix64F Q, boolean compact) {
        Q = compact ? UtilDecompositons_CD64.checkIdentity(Q, this.numRows, this.minLength) : UtilDecompositons_CD64.checkIdentity(Q, this.numRows, this.numRows);
        for (int j = this.minLength - 1; j >= 0; --j) {
            int diagIndex = (j * this.numRows + j) * 2;
            double realBefore = this.QR.data[diagIndex];
            double imagBefore = this.QR.data[diagIndex + 1];
            this.QR.data[diagIndex] = 1.0;
            this.QR.data[diagIndex + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(Q, this.QR.data, j * this.numRows, this.gammas[j], j, j, this.numRows, this.v);
            this.QR.data[diagIndex] = realBefore;
            this.QR.data[diagIndex + 1] = imagBefore;
        }
        return Q;
    }

    public void applyQ(CDenseMatrix64F A) {
        if (A.numRows != this.numRows) {
            throw new IllegalArgumentException("A must have at least " + this.numRows + " rows.");
        }
        for (int j = this.minLength - 1; j >= 0; --j) {
            int diagIndex = (j * this.numRows + j) * 2;
            double realBefore = this.QR.data[diagIndex];
            double imagBefore = this.QR.data[diagIndex + 1];
            this.QR.data[diagIndex] = 1.0;
            this.QR.data[diagIndex + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(A, this.QR.data, j * this.numRows, this.gammas[j], 0, j, this.numRows, this.v);
            this.QR.data[diagIndex] = realBefore;
            this.QR.data[diagIndex + 1] = imagBefore;
        }
    }

    public void applyTranQ(CDenseMatrix64F A) {
        for (int j = 0; j < this.minLength; ++j) {
            int diagIndex = (j * this.numRows + j) * 2;
            double realBefore = this.QR.data[diagIndex];
            double imagBefore = this.QR.data[diagIndex + 1];
            this.QR.data[diagIndex] = 1.0;
            this.QR.data[diagIndex + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(A, this.QR.data, j * this.numRows, this.gammas[j], 0, j, this.numRows, this.v);
            this.QR.data[diagIndex] = realBefore;
            this.QR.data[diagIndex + 1] = imagBefore;
        }
    }

    public CDenseMatrix64F getR(CDenseMatrix64F R, boolean compact) {
        R = compact ? UtilDecompositons_CD64.checkZerosLT(R, this.minLength, this.numCols) : UtilDecompositons_CD64.checkZerosLT(R, this.numRows, this.numCols);
        for (int i = 0; i < R.numRows; ++i) {
            for (int j = i; j < R.numCols; ++j) {
                int index = this.QR.getIndex(j, i);
                R.set(i, j, this.QR.data[index], this.QR.data[index + 1]);
            }
        }
        return R;
    }

    public boolean decompose(CDenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        CCommonOps.transpose(A, this.QR);
        this.error = false;
        for (int j = 0; j < this.minLength; ++j) {
            this.householder(j);
            this.updateA(j);
        }
        return !this.error;
    }

    public boolean inputModified() {
        return false;
    }

    protected void householder(int j) {
        int startQR = j * this.numRows;
        int endQR = startQR + this.numRows;
        double max = QrHelperFunctions_CD64.findMax(this.QR.data, startQR += j, this.numRows - j);
        if (max == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.gamma = QrHelperFunctions_CD64.computeTauGammaAndDivide(startQR, endQR, this.QR.data, max, this.tau);
            double realU0 = this.QR.data[startQR * 2] + this.tau.real;
            double imagU0 = this.QR.data[startQR * 2 + 1] + this.tau.imaginary;
            QrHelperFunctions_CD64.divideElements(startQR + 1, endQR, this.QR.data, 0, realU0, imagU0);
            this.tau.real *= max;
            this.tau.imaginary *= max;
            this.QR.data[startQR * 2] = -this.tau.real;
            this.QR.data[startQR * 2 + 1] = -this.tau.imaginary;
        }
        this.gammas[j] = this.gamma;
    }

    protected void updateA(int w) {
        double[] data = this.QR.data;
        int rowW = w * this.numRows + w + 1;
        int rowJ = rowW + this.numRows;
        int rowJEnd = 2 * (rowJ + (this.numCols - w - 1) * this.numRows);
        int indexWEnd = 2 * (rowW + this.numRows - w - 1);
        rowW = 2 * rowW;
        for (rowJ = 2 * rowJ; rowJEnd != rowJ; rowJ += this.numRows * 2) {
            double imagW;
            double realW;
            double realVal = data[rowJ - 2];
            double imagVal = data[rowJ - 1];
            int indexW = rowW;
            int indexJ = rowJ;
            while (indexW != indexWEnd) {
                realW = data[indexW++];
                imagW = -data[indexW++];
                double realJ = data[indexJ++];
                double imagJ = data[indexJ++];
                realVal += realW * realJ - imagW * imagJ;
                imagVal += realW * imagJ + imagW * realJ;
            }
            int n = rowJ - 2;
            data[n] = data[n] - (realVal *= this.gamma);
            int n2 = rowJ - 1;
            data[n2] = data[n2] - (imagVal *= this.gamma);
            indexW = rowW;
            indexJ = rowJ;
            while (indexW != indexWEnd) {
                realW = data[indexW++];
                imagW = data[indexW++];
                int n3 = indexJ++;
                data[n3] = data[n3] - (realW * realVal - imagW * imagVal);
                int n4 = indexJ++;
                data[n4] = data[n4] - (realW * imagVal + imagW * realVal);
            }
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

