/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.buildversion.AbstractVersionMojo;

@Mojo(name="validate-version", defaultPhase=LifecyclePhase.VALIDATE)
public class ValidateVersionMojo
extends AbstractVersionMojo {
    @Parameter(defaultValue="true")
    private boolean strictVersions = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String mavenVersion = this.project.getVersion();
        String osgiVersion = this.getOSGiVersion();
        if (osgiVersion == null) {
            return;
        }
        if (this.project.getArtifact().isSnapshot() || osgiVersion.endsWith("qualifier")) {
            this.validateSnapshotVersion(mavenVersion, osgiVersion);
        } else {
            this.validateReleaseVersion(mavenVersion, osgiVersion);
        }
    }

    public void validateReleaseVersion(String mavenVersion, String osgiVersion) throws MojoExecutionException {
        if (!mavenVersion.equals(osgiVersion)) {
            this.fail("OSGi version " + osgiVersion + " in " + this.getOSGiMetadataFileName() + " does not match Maven version " + mavenVersion + " in pom.xml");
        }
    }

    private String getOSGiMetadataFileName() {
        String packaging = this.project.getPackaging();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            return "META-INF/MANIFEST.MF";
        }
        if ("eclipse-feature".equals(packaging)) {
            return "feature.xml";
        }
        if ("eclipse-application".equals(packaging)) {
            return this.project.getArtifactId() + ".product";
        }
        if ("eclipse-repository".equals(packaging)) {
            return this.project.getArtifactId();
        }
        if ("p2-installable-unit".equals(packaging)) {
            return "p2iu.xml";
        }
        return "<unknown packaging=" + packaging + ">";
    }

    public void validateSnapshotVersion(String mavenVersion, String osgiVersion) throws MojoExecutionException {
        if (!mavenVersion.endsWith("SNAPSHOT")) {
            this.fail("Maven version " + mavenVersion + " must have -SNAPSHOT qualifier for SNAPSHOT builds");
        }
        if (!osgiVersion.endsWith("qualifier")) {
            this.fail("OSGi version " + osgiVersion + " must have .qualifier qualifier for SNAPSHOT builds");
        } else {
            String unqualifiedOSGiVersion;
            String unqualifiedMavenVersion = mavenVersion;
            if (mavenVersion.endsWith("SNAPSHOT")) {
                unqualifiedMavenVersion = mavenVersion.substring(0, mavenVersion.length() - "SNAPSHOT".length() - 1);
            }
            if (!unqualifiedMavenVersion.equals(unqualifiedOSGiVersion = osgiVersion.substring(0, osgiVersion.length() - "qualifier".length() - 1))) {
                this.fail("Unqualified OSGi version " + osgiVersion + " must match unqualified Maven version " + mavenVersion + " for SNAPSHOT builds");
            }
        }
    }

    private void fail(String message) throws MojoExecutionException {
        if (this.strictVersions) {
            throw new MojoExecutionException(message);
        }
        this.getLog().warn((CharSequence)message);
    }
}

