/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

@Mojo(name="publish-categories", defaultPhase=LifecyclePhase.PACKAGE)
public final class PublishCategoriesMojo
extends AbstractPublishMojo {
    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        PublisherService publisherService = publisherServiceFactory.createPublisher(this.getReactorProject(), this.getEnvironments());
        try {
            ArrayList<DependencySeed> categoryIUs = new ArrayList<DependencySeed>();
            for (Category category : this.getCategories()) {
                File buildCategoryFile = this.prepareBuildCategory(category, this.getBuildDirectory());
                Collection ius = publisherService.publishCategories(buildCategoryFile);
                categoryIUs.addAll(ius);
            }
            return categoryIUs;
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Exception while publishing categories: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private File prepareBuildCategory(Category category, BuildOutputDirectory buildFolder) throws MojoExecutionException {
        try {
            File ret = buildFolder.getChild("category.xml");
            buildFolder.getLocation().mkdirs();
            Category.write((Category)category, (File)ret);
            this.copySiteI18nFiles(buildFolder);
            return ret;
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing category definition to disk", (Exception)e);
        }
    }

    private void copySiteI18nFiles(BuildOutputDirectory buildFolder) throws IOException {
        File[] i18nFiles = this.getProject().getBasedir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                return fileName.startsWith("site") && fileName.endsWith(".properties");
            }
        });
        if (i18nFiles == null) {
            return;
        }
        for (File i18nFile : i18nFiles) {
            FileUtils.copyFile((File)i18nFile, (File)buildFolder.getChild(i18nFile.getName()));
        }
    }

    private List<Category> getCategories() {
        return this.getEclipseRepositoryProject().loadCategories(this.getProject());
    }
}

