/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.tar;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class FilePermissionHelper {
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;

    private FilePermissionHelper() {
    }

    public static int toOctalFileMode(Set<PosixFilePermission> permissions) {
        int result = 0;
        for (PosixFilePermission permissionBit : permissions) {
            switch (permissionBit) {
                case OWNER_READ: {
                    result |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    break;
                }
                case OTHERS_READ: {
                    result |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                }
            }
        }
        return result;
    }
}

