/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.util.List;
import org.eclipse.tycho.core.shared.TargetEnvironment;

public class ProfileName {
    private String name;
    private String os;
    private String ws;
    private String arch;

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getOs() {
        return this.os;
    }

    public String getWs() {
        return this.ws;
    }

    public ProfileName() {
    }

    public ProfileName(String name) {
        this(name, null, null, null);
    }

    public ProfileName(String name, String os, String ws, String arch) {
        this.name = name;
        this.ws = ws;
        this.os = os;
        this.arch = arch;
    }

    public static String getNameForEnvironment(TargetEnvironment env, List<ProfileName> nameMap, String defaultName) {
        if (nameMap != null) {
            for (ProfileName profileWithEnvironment : nameMap) {
                if (!env.match(profileWithEnvironment.getOs(), profileWithEnvironment.getWs(), profileWithEnvironment.getArch())) continue;
                return profileWithEnvironment.getName();
            }
        }
        return defaultName;
    }
}

