/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ArtifactComparator.class, hint="zip")
public class ZipComparatorImpl
implements ArtifactComparator {
    public static final String TYPE = "zip";
    private static final Collection<String> IGNORED_PATTERNS;
    @Requirement
    private Logger log;
    @Requirement
    private Map<String, ContentsComparator> comparators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundArtifactDelta getDelta(File baseline, File reactor, MojoExecution execution) throws IOException {
        Xpp3Dom ignoredPatternsNode;
        Xpp3Dom pluginConfiguration;
        LinkedHashMap<String, ArtifactDelta> result = new LinkedHashMap<String, ArtifactDelta>();
        HashSet<String> ignoredPatterns = new HashSet<String>(IGNORED_PATTERNS);
        if (execution != null && (pluginConfiguration = (Xpp3Dom)execution.getPlugin().getConfiguration()) != null && (ignoredPatternsNode = pluginConfiguration.getChild("ignoredPatterns")) != null) {
            for (Xpp3Dom node : ignoredPatternsNode.getChildren()) {
                ignoredPatterns.add(node.getValue());
            }
        }
        ZipFile jar = new ZipFile(baseline);
        try {
            ZipFile jar2 = new ZipFile(reactor);
            try {
                Map<String, ZipEntry> entries = ZipComparatorImpl.toEntryMap(jar, ignoredPatterns);
                Map<String, ZipEntry> entries2 = ZipComparatorImpl.toEntryMap(jar2, ignoredPatterns);
                TreeSet<String> names = new TreeSet<String>();
                names.addAll(entries.keySet());
                names.addAll(entries2.keySet());
                for (String name : names) {
                    ZipEntry entry = entries.get(name);
                    if (entry == null) {
                        result.put(name, new SimpleArtifactDelta("not present in baseline"));
                        continue;
                    }
                    ZipEntry entry2 = entries2.get(name);
                    if (entry2 == null) {
                        result.put(name, new SimpleArtifactDelta("present in baseline only"));
                        continue;
                    }
                    InputStream is = jar.getInputStream(entry);
                    try {
                        InputStream is2 = jar2.getInputStream(entry2);
                        try {
                            ContentsComparator comparator = this.comparators.get(this.getContentType(name));
                            ArtifactDelta differences = comparator.getDelta(is, is2, execution);
                            if (differences == null) continue;
                            result.put(name, differences);
                        }
                        finally {
                            IOUtil.close((InputStream)is2);
                        }
                    }
                    finally {
                        IOUtil.close((InputStream)is);
                    }
                }
            }
            finally {
                try {
                    jar2.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : null;
    }

    private String getContentType(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).endsWith(".class")) {
            return "class";
        }
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return TYPE;
        }
        if (name.endsWith(".properties") || name.endsWith(".mappings")) {
            return "properties";
        }
        if ("meta-inf/manifest.mf".equals(name)) {
            return "manifest";
        }
        return "default";
    }

    private static Map<String, ZipEntry> toEntryMap(ZipFile zip, Collection<String> ignoredPatterns) {
        LinkedHashMap<String, ZipEntry> result = new LinkedHashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || ZipComparatorImpl.isIgnored(entry.getName(), ignoredPatterns)) continue;
            result.put(entry.getName(), entry);
        }
        return result;
    }

    private static boolean isIgnored(String name, Collection<String> ignoredPatterns) {
        for (String pattern : ignoredPatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)name, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> ignoredPatterns = new ArrayList<String>();
        ignoredPatterns.add("meta-inf/maven/**");
        IGNORED_PATTERNS = Collections.unmodifiableList(ignoredPatterns);
    }
}

