/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.embedder.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.sisu.equinox.embedder.EquinoxRuntimeLocator;
import org.eclipse.sisu.equinox.embedder.internal.EquinoxEmbedderException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Component(role=EquinoxServiceFactory.class)
public class DefaultEquinoxEmbedder
extends AbstractLogEnabled
implements EquinoxServiceFactory,
EmbeddedEquinox,
Disposable {
    @Requirement(role=EquinoxLifecycleListener.class)
    private Map<String, EquinoxLifecycleListener> lifecycleListeners;
    @Requirement
    private EquinoxRuntimeLocator equinoxLocator;
    private BundleContext frameworkContext;
    private File tempSecureStorage;
    private File tempEquinoxDir;

    public synchronized void start() throws Exception {
        if (this.frameworkContext != null) {
            return;
        }
        if ("Eclipse".equals(System.getProperty("org.osgi.framework.vendor"))) {
            throw new IllegalStateException("Cannot run multiple Equinox instances in one build. Consider configuring the Tycho build extension, so that all mojos using Tycho functionality share the same Equinox runtime.");
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void doStart() throws Exception {
        final ArrayList installationLocations = new ArrayList();
        final ArrayList bundleLocations = new ArrayList();
        final ArrayList extraSystemPackages = new ArrayList();
        final LinkedHashMap<String, String> platformProperties = new LinkedHashMap<String, String>();
        this.equinoxLocator.locateRuntime(new EquinoxRuntimeLocator.EquinoxRuntimeDescription(){

            @Override
            public void addExtraSystemPackage(String systemPackage) {
                if (systemPackage == null || systemPackage.length() == 0) {
                    throw new IllegalArgumentException();
                }
                extraSystemPackages.add(systemPackage);
            }

            @Override
            public void addPlatformProperty(String property, String value) {
                if (property == null || property.length() == 0) {
                    throw new IllegalArgumentException();
                }
                platformProperties.put(property, value);
            }

            @Override
            public void addInstallation(File location) {
                if (location == null || !location.isDirectory() || !new File(location, "plugins").isDirectory()) {
                    throw new IllegalArgumentException();
                }
                if (!installationLocations.isEmpty()) {
                    throw new IllegalStateException();
                }
                installationLocations.add(location);
            }

            @Override
            public void addBundle(File location) {
                if (location == null || !location.exists()) {
                    throw new IllegalArgumentException();
                }
                if (!DefaultEquinoxEmbedder.this.isFrameworkBundle(location)) {
                    bundleLocations.add(location);
                }
            }

            @Override
            public void addBundleStartLevel(String id, int level, boolean autostart) {
            }
        });
        if (installationLocations.isEmpty() && !platformProperties.containsKey("osgi.install.area")) {
            throw new RuntimeException("Equinox runtime location is missing or invalid");
        }
        System.setProperty("osgi.framework.useSystemProperties", "false");
        StringBuilder bundles = new StringBuilder();
        if (!installationLocations.isEmpty()) {
            File frameworkDir = (File)installationLocations.get(0);
            String frameworkLocation = frameworkDir.getAbsolutePath();
            platformProperties.put("osgi.install.area", frameworkLocation);
            platformProperties.put("osgi.syspath", frameworkLocation + "/plugins");
            platformProperties.put("osgi.configuration.area", this.copyToTempFolder(new File(frameworkDir, "configuration")));
            this.addBundlesDir(bundles, new File(frameworkDir, "plugins").listFiles(), false);
        }
        for (Object location : bundleLocations) {
            if (bundles.length() > 0) {
                bundles.append(',');
            }
            bundles.append(this.getReferenceUrl((File)location));
        }
        platformProperties.put("osgi.bundles", bundles.toString());
        platformProperties.put("osgi.parentClassloader", "fwk");
        if (extraSystemPackages.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String pkg : extraSystemPackages) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(pkg);
            }
            platformProperties.put("org.osgi.framework.system.packages.extra", sb.toString());
        }
        EclipseStarter.setInitialProperties(platformProperties);
        EclipseStarter.startup((String[])this.getNonFrameworkArgs(), null);
        this.frameworkContext = EclipseStarter.getSystemBundleContext();
        this.activateBundlesInWorkingOrder();
        for (EquinoxLifecycleListener listener : this.lifecycleListeners.values()) {
            listener.afterFrameworkStarted(this);
        }
    }

    private String copyToTempFolder(File configDir) throws IOException {
        File equinoxTmp = File.createTempFile("tycho", "equinox");
        if (!equinoxTmp.delete() || !equinoxTmp.mkdirs()) {
            throw new IOException("Could not create temp dir " + equinoxTmp);
        }
        File tempConfigDir = new File(equinoxTmp, "config");
        if (!tempConfigDir.mkdirs()) {
            throw new IOException("Could not create temp config dir " + tempConfigDir);
        }
        FileUtils.copyFileToDirectory((File)new File(configDir, "config.ini"), (File)tempConfigDir);
        this.tempEquinoxDir = equinoxTmp;
        return tempConfigDir.getAbsolutePath();
    }

    private void activateBundlesInWorkingOrder() {
        this.tryActivateBundle("org.eclipse.equinox.ds");
        this.tryActivateBundle("org.eclipse.equinox.registry");
        this.tryActivateBundle("org.eclipse.core.net");
    }

    private void tryActivateBundle(String symbolicName) {
        for (Bundle bundle : this.frameworkContext.getBundles()) {
            if (!symbolicName.equals(bundle.getSymbolicName())) continue;
            try {
                bundle.start(1);
            }
            catch (BundleException e) {
                this.getLogger().warn("Could not start bundle " + bundle.getSymbolicName(), (Throwable)e);
            }
        }
    }

    private void addBundlesDir(StringBuilder bundles, File[] files, boolean absolute) {
        if (files != null) {
            for (File file : files) {
                if (this.isFrameworkBundle(file)) continue;
                if (bundles.length() > 0) {
                    bundles.append(',');
                }
                if (absolute) {
                    bundles.append(this.getReferenceUrl(file));
                    continue;
                }
                String name = file.getName();
                int verIdx = name.indexOf(95);
                if (verIdx > 0) {
                    bundles.append(name.substring(0, verIdx));
                    continue;
                }
                throw new EquinoxEmbedderException("File name doesn't match expected pattern: " + file);
            }
        }
    }

    protected boolean isFrameworkBundle(File file) {
        return file.getName().startsWith("org.eclipse.osgi_");
    }

    String getReferenceUrl(File file) {
        return "reference:file:" + file.getAbsoluteFile().toURI().normalize().getPath();
    }

    private String[] getNonFrameworkArgs() {
        try {
            this.tempSecureStorage = File.createTempFile("tycho", "secure_storage");
            this.tempSecureStorage.deleteOnExit();
        }
        catch (IOException e) {
            throw new EquinoxEmbedderException("Could not create Tycho secure store file in temp dir " + System.getProperty("java.io.tmpdir"), e);
        }
        ArrayList<String> nonFrameworkArgs = new ArrayList<String>();
        nonFrameworkArgs.add("-eclipse.keyring");
        nonFrameworkArgs.add(this.tempSecureStorage.getAbsolutePath());
        if (this.getLogger().isDebugEnabled()) {
            nonFrameworkArgs.add("-debug");
            nonFrameworkArgs.add("-consoleLog");
        }
        return nonFrameworkArgs.toArray(new String[0]);
    }

    public <T> T getService(Class<T> clazz) {
        return this.getService(clazz, null);
    }

    public <T> T getService(Class<T> clazz, String filter) {
        ServiceReference[] serviceReferences;
        this.checkStarted();
        try {
            serviceReferences = this.frameworkContext.getServiceReferences(clazz.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Service is not registered class='").append(clazz).append("'");
            if (filter != null) {
                sb.append("filter='").append(filter).append("'");
            }
            throw new IllegalStateException(sb.toString());
        }
        return clazz.cast(this.frameworkContext.getService(serviceReferences[0]));
    }

    private void checkStarted() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void registerService(Class<T> clazz, T service) {
        this.registerService(clazz, service, new Hashtable(1));
    }

    @Override
    public <T> void registerService(Class<T> clazz, T service, Dictionary<String, ?> properties) {
        this.frameworkContext.registerService(clazz, service, properties);
    }

    public void dispose() {
        if (this.frameworkContext != null) {
            try {
                EclipseStarter.shutdown();
            }
            catch (Exception e) {
                this.getLogger().error("Exception while shutting down equinox", (Throwable)e);
            }
            this.tempSecureStorage.delete();
            if (this.tempEquinoxDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.tempEquinoxDir);
                }
                catch (IOException e) {
                    this.getLogger().warn("Exception while deleting temp folder " + this.tempEquinoxDir, (Throwable)e);
                }
            }
            this.frameworkContext = null;
        }
    }

    @Override
    public EquinoxServiceFactory getServiceFactory() {
        return this;
    }
}

