/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.extras;

import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Repository {
    private String id;
    private URI url;
    private Layout layout = Layout.BOTH;

    public Repository() {
    }

    Repository(URI location) {
        this.url = location;
    }

    public URI getLocation() {
        if (this.url == null) {
            throw new IllegalStateException("Attribute 'url' is required for source repositories");
        }
        return this.url;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public String getId() {
        return this.id;
    }

    public void setLayout(String value) {
        for (Layout layout : Layout.values()) {
            if (!layout.matches(value)) continue;
            this.layout = layout;
            return;
        }
        throw new IllegalArgumentException("Unrecognized value for attribute 'layout': \"" + value + "\". Valid values are: " + this.listValues(Layout.values()));
    }

    private String listValues(Enum<?> ... values) {
        StringBuilder result = new StringBuilder();
        String separator = ", ";
        for (Enum<?> value : values) {
            result.append(value.toString());
            result.append(separator);
        }
        return result.substring(0, result.length() - separator.length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        BOTH("p2"),
        METADATA("p2-metadata"),
        ARTIFACTS("p2-artifacts");

        private String literal;

        private Layout(String literal) {
            this.literal = literal;
        }

        boolean matches(String value) {
            return this.literal.equals(value);
        }

        public boolean hasMetadata() {
            return this != ARTIFACTS;
        }

        public boolean hasArtifacts() {
            return this != METADATA;
        }

        public String toString() {
            return this.literal;
        }
    }
}

