/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class PathName
implements Comparable<PathName> {
    private final String[] segments;

    public PathName(String[] segments) {
        Objects.requireNonNull(segments);
        this.segments = Arrays.copyOf(segments, segments.length);
    }

    public PathName(List<String> segments) {
        Objects.requireNonNull(segments);
        this.segments = segments.toArray(new String[segments.size()]);
    }

    public String[] getSegments() {
        return this.segments;
    }

    public String getBasename() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public String getDirname() {
        if (this.segments.length <= 1) {
            return "";
        }
        return Arrays.stream(this.segments, 0, this.segments.length - 1).collect(this.joiner());
    }

    public String toString() {
        return Arrays.stream(this.segments).collect(this.joiner());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathName other = (PathName)obj;
        return Arrays.equals(this.segments, other.segments);
    }

    @Override
    public int compareTo(PathName o) {
        return this.toString().compareTo(o.toString());
    }

    private Collector<CharSequence, ?, String> joiner() {
        return Collectors.joining("/");
    }

    public static PathName parse(String name) {
        String[] parsed = name.split("/+");
        ArrayList<String> segs = new ArrayList<String>(parsed.length);
        for (String seg : parsed) {
            if (seg.isEmpty()) continue;
            segs.add(seg);
        }
        return new PathName(segs);
    }
}

