/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.subscriptions.BatchModifyMonitoredItems;
import org.eclipse.milo.opcua.sdk.client.subscriptions.BatchSetMonitoringMode;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public abstract class ManagedItem {
    protected final OpcUaClient client;
    protected final ManagedSubscription subscription;
    protected final OpcUaMonitoredItem monitoredItem;

    ManagedItem(OpcUaClient client, ManagedSubscription subscription, OpcUaMonitoredItem monitoredItem) {
        this.client = client;
        this.subscription = subscription;
        this.monitoredItem = monitoredItem;
    }

    public OpcUaClient getClient() {
        return this.client;
    }

    public ManagedSubscription getSubscription() {
        return this.subscription;
    }

    public OpcUaMonitoredItem getMonitoredItem() {
        return this.monitoredItem;
    }

    public NodeId getNodeId() {
        return this.getReadValueId().getNodeId();
    }

    public ReadValueId getReadValueId() {
        return this.monitoredItem.getReadValueId();
    }

    public StatusCode getStatusCode() {
        return this.monitoredItem.getStatusCode();
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoredItem.getMonitoringMode();
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) throws UaException {
        try {
            this.setMonitoringModeAsync(monitoringMode).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> setMonitoringModeAsync(MonitoringMode monitoringMode) {
        CompletableFuture<List<StatusCode>> future = this.subscription.getSubscription().setMonitoringMode(monitoringMode, Collections.singletonList(this.monitoredItem));
        return ((CompletableFuture)future.thenApply(statusCodes -> (StatusCode)statusCodes.get(0))).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public CompletableFuture<Unit> setMonitoringModeAsync(MonitoringMode monitoringMode, BatchSetMonitoringMode batch) {
        CompletableFuture<BatchSetMonitoringMode.SetMonitoringModeResult> future = batch.add(this.getMonitoredItem(), monitoringMode);
        return future.thenCompose(result -> {
            if (result.isServiceResultGood()) {
                Optional<CompletableFuture> opt = result.operationResult().map(s -> {
                    if (s.isGood()) {
                        return CompletableFuture.completedFuture(Unit.VALUE);
                    }
                    return FutureUtils.failedUaFuture((StatusCode)s);
                });
                return opt.orElse(FutureUtils.failedUaFuture((StatusCode)new StatusCode(0x80020000L)));
            }
            return FutureUtils.failedUaFuture((StatusCode)result.serviceResult());
        });
    }

    public UInteger getQueueSize() {
        return this.monitoredItem.getRevisedQueueSize();
    }

    public UInteger setQueueSize(UInteger queueSize) throws UaException {
        try {
            return this.setQueueSizeAsync(queueSize).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<UInteger> setQueueSizeAsync(UInteger queueSize) {
        MonitoringParameters parameters = new MonitoringParameters(this.monitoredItem.getClientHandle(), Double.valueOf(this.monitoredItem.getRevisedSamplingInterval()), this.monitoredItem.getMonitoringFilter(), queueSize, Boolean.valueOf(this.monitoredItem.getDiscardOldest()));
        MonitoredItemModifyRequest modifyRequest = new MonitoredItemModifyRequest(this.monitoredItem.getMonitoredItemId(), parameters);
        CompletableFuture<List<StatusCode>> future = this.subscription.getSubscription().modifyMonitoredItems(this.monitoredItem.getTimestamps(), Collections.singletonList(modifyRequest));
        return ((CompletableFuture)future.thenApply(statusCodes -> (StatusCode)statusCodes.get(0))).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(this.monitoredItem.getRevisedQueueSize());
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public CompletableFuture<UInteger> setQueueSizeAsync(UInteger queueSize, BatchModifyMonitoredItems batch) {
        CompletableFuture<BatchModifyMonitoredItems.ModifyMonitoredItemResult> future = batch.add(this.getMonitoredItem(), b -> b.setQueueSize(queueSize));
        return future.thenCompose(result -> {
            if (result.isServiceResultGood()) {
                Optional<CompletableFuture> opt = result.operationResult().map(s -> {
                    if (s.isGood()) {
                        return CompletableFuture.completedFuture(this.getQueueSize());
                    }
                    return FutureUtils.failedUaFuture((StatusCode)s);
                });
                return opt.orElse(FutureUtils.failedUaFuture((StatusCode)new StatusCode(0x80020000L)));
            }
            return FutureUtils.failedUaFuture((StatusCode)result.serviceResult());
        });
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.monitoredItem.getTimestamps();
    }

    public void setTimestampsToReturn(TimestampsToReturn timestamps) throws UaException {
        try {
            this.setTimestampsToReturnAsync(timestamps).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> setTimestampsToReturnAsync(TimestampsToReturn timestamps) {
        MonitoringParameters parameters = new MonitoringParameters(this.monitoredItem.getClientHandle(), Double.valueOf(this.monitoredItem.getRevisedSamplingInterval()), this.monitoredItem.getMonitoringFilter(), this.monitoredItem.getRevisedQueueSize(), Boolean.valueOf(this.monitoredItem.getDiscardOldest()));
        MonitoredItemModifyRequest modifyRequest = new MonitoredItemModifyRequest(this.monitoredItem.getMonitoredItemId(), parameters);
        CompletableFuture<List<StatusCode>> future = this.subscription.getSubscription().modifyMonitoredItems(timestamps, Collections.singletonList(modifyRequest));
        return ((CompletableFuture)future.thenApply(statusCodes -> (StatusCode)statusCodes.get(0))).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public CompletableFuture<Unit> setTimestampsToReturnAsync(TimestampsToReturn timestamps, BatchModifyMonitoredItems batch) {
        CompletableFuture<BatchModifyMonitoredItems.ModifyMonitoredItemResult> future = batch.add(this.getMonitoredItem(), b -> b.setTimestamps(timestamps));
        return future.thenCompose(result -> {
            if (result.isServiceResultGood()) {
                Optional<CompletableFuture> opt = result.operationResult().map(s -> {
                    if (s.isGood()) {
                        return CompletableFuture.completedFuture(Unit.VALUE);
                    }
                    return FutureUtils.failedUaFuture((StatusCode)s);
                });
                return opt.orElse(FutureUtils.failedUaFuture((StatusCode)new StatusCode(0x80020000L)));
            }
            return FutureUtils.failedUaFuture((StatusCode)result.serviceResult());
        });
    }

    public boolean getDiscardOldest() {
        return this.monitoredItem.getDiscardOldest();
    }

    public void setDiscardOldest(boolean discardOldest) throws UaException {
        try {
            this.setDiscardOldestAsync(discardOldest).get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<Unit> setDiscardOldestAsync(boolean discardOldest) {
        MonitoringParameters parameters = new MonitoringParameters(this.monitoredItem.getClientHandle(), Double.valueOf(this.monitoredItem.getRevisedSamplingInterval()), this.monitoredItem.getMonitoringFilter(), this.monitoredItem.getRevisedQueueSize(), Boolean.valueOf(discardOldest));
        MonitoredItemModifyRequest modifyRequest = new MonitoredItemModifyRequest(this.monitoredItem.getMonitoredItemId(), parameters);
        CompletableFuture<List<StatusCode>> future = this.subscription.getSubscription().modifyMonitoredItems(this.monitoredItem.getTimestamps(), Collections.singletonList(modifyRequest));
        return ((CompletableFuture)future.thenApply(statusCodes -> (StatusCode)statusCodes.get(0))).thenCompose(statusCode -> {
            if (statusCode.isGood()) {
                return CompletableFuture.completedFuture(Unit.VALUE);
            }
            return FutureUtils.failedUaFuture((StatusCode)statusCode);
        });
    }

    public CompletableFuture<Unit> setDiscardOldestAsync(boolean discardOldest, BatchModifyMonitoredItems batch) {
        CompletableFuture<BatchModifyMonitoredItems.ModifyMonitoredItemResult> future = batch.add(this.getMonitoredItem(), b -> b.setDiscardOldest(discardOldest));
        return future.thenCompose(result -> {
            if (result.isServiceResultGood()) {
                Optional<CompletableFuture> opt = result.operationResult().map(s -> {
                    if (s.isGood()) {
                        return CompletableFuture.completedFuture(Unit.VALUE);
                    }
                    return FutureUtils.failedUaFuture((StatusCode)s);
                });
                return opt.orElse(FutureUtils.failedUaFuture((StatusCode)new StatusCode(0x80020000L)));
            }
            return FutureUtils.failedUaFuture((StatusCode)result.serviceResult());
        });
    }

    public void delete() throws UaException {
        try {
            this.deleteAsync().get();
        }
        catch (InterruptedException e) {
            throw new UaException(0x80010000L, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public abstract CompletableFuture<Unit> deleteAsync();
}

