/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.request;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.request.CoapRequestBuilder;
import org.eclipse.leshan.client.californium.request.LwM2mClientResponseBuilder;
import org.eclipse.leshan.client.request.LwM2mRequestSender;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.californium.AsyncRequestObserver;
import org.eclipse.leshan.core.californium.SyncRequestObserver;
import org.eclipse.leshan.core.link.LinkSerializer;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.request.UplinkRequestVisitor;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumLwM2mRequestSender
implements LwM2mRequestSender {
    private static final Logger LOG = LoggerFactory.getLogger(CaliforniumLwM2mRequestSender.class);
    private final ScheduledExecutorService executor;
    private final boolean attached;
    private final CaliforniumEndpointsManager endpointsManager;
    private final LwM2mEncoder encoder;
    private final LwM2mModel model;
    private final LinkSerializer linkSerializer;

    public CaliforniumLwM2mRequestSender(CaliforniumEndpointsManager endpointsManager, ScheduledExecutorService sharedExecutor, LwM2mEncoder encoder, LwM2mModel model, LinkSerializer linkSerializer) {
        this.endpointsManager = endpointsManager;
        this.linkSerializer = linkSerializer;
        if (sharedExecutor == null) {
            this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
            this.attached = false;
        } else {
            this.executor = sharedExecutor;
            this.attached = false;
        }
        this.model = model;
        this.encoder = encoder;
    }

    public <T extends LwM2mResponse> T send(ServerIdentity server, final UplinkRequest<T> request, long timeout) throws InterruptedException {
        CoapRequestBuilder coapClientRequestBuilder = new CoapRequestBuilder(server.getIdentity(), this.encoder, this.model, this.linkSerializer);
        request.accept((UplinkRequestVisitor)coapClientRequestBuilder);
        Request coapRequest = coapClientRequestBuilder.getRequest();
        SyncRequestObserver syncMessageObserver = new SyncRequestObserver<T>(coapRequest, timeout){

            public T buildResponse(Response coapResponse) {
                LwM2mClientResponseBuilder lwm2mResponseBuilder = new LwM2mClientResponseBuilder(coapResponse);
                request.accept(lwm2mResponseBuilder);
                return lwm2mResponseBuilder.getResponse();
            }
        };
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.endpointsManager.getEndpoint(server).sendRequest(coapRequest);
        return (T)syncMessageObserver.waitForResponse();
    }

    public <T extends LwM2mResponse> void send(ServerIdentity server, final UplinkRequest<T> request, long timeout, ResponseCallback<T> responseCallback, ErrorCallback errorCallback) {
        CoapRequestBuilder coapClientRequestBuilder = new CoapRequestBuilder(server.getIdentity(), this.encoder, this.model, this.linkSerializer);
        request.accept((UplinkRequestVisitor)coapClientRequestBuilder);
        Request coapRequest = coapClientRequestBuilder.getRequest();
        AsyncRequestObserver obs = new AsyncRequestObserver<T>(coapRequest, responseCallback, errorCallback, timeout, this.executor){

            public T buildResponse(Response coapResponse) {
                LwM2mClientResponseBuilder lwm2mResponseBuilder = new LwM2mClientResponseBuilder(coapResponse);
                request.accept(lwm2mResponseBuilder);
                return lwm2mResponseBuilder.getResponse();
            }
        };
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.endpointsManager.getEndpoint(server).sendRequest(coapRequest);
    }

    public void destroy() {
        if (this.attached) {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Destroying RequestSender was interrupted.", (Throwable)e);
            }
        }
    }
}

