/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.bootstrap;

import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.SendableResponse;

public class BootstrapResource
extends LwM2mClientCoapResource {
    protected BootstrapHandler bootstrapHandler;

    public BootstrapResource(RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler) {
        super("bs", registrationEngine, endpointsManager);
        this.bootstrapHandler = bootstrapHandler;
        this.setVisible(false);
    }

    public void handlePOST(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        exchange.accept();
        Request coapRequest = exchange.advanced().getRequest();
        final SendableResponse sendableResponse = this.bootstrapHandler.finished(identity, new BootstrapFinishRequest((Object)coapRequest));
        Response coapResponse = new Response(ResponseCodeUtil.toCoapResponseCode((ResponseCode)((BootstrapFinishResponse)sendableResponse.getResponse()).getCode()));
        if (((BootstrapFinishResponse)sendableResponse.getResponse()).getCode().isError()) {
            coapResponse.setConfirmable(true);
            coapResponse.setPayload(((BootstrapFinishResponse)sendableResponse.getResponse()).getErrorMessage());
            coapResponse.getOptions().setContentFormat(0);
        }
        coapResponse.addMessageObserver((MessageObserver)new MessageObserverAdapter(){

            public void onAcknowledgement() {
                sendableResponse.sent();
            }
        });
        exchange.respond(coapResponse);
    }
}

