/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public final class FS {
    private FS() {
    }

    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            FS.deleteFile(path);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            FS.deleteDirectory(path);
        } else {
            Assertions.fail("Not able to delete path, not a file or directory? : " + path.toAbsolutePath());
        }
    }

    public static void delete(File path) {
        FS.delete(path.toPath());
    }

    public static void deleteDirectory(File dir) {
        FS.deleteDirectory(dir.toPath());
    }

    public static void deleteDirectory(Path dir) {
        FS.recursiveDeleteDir(dir);
    }

    public static void deleteFile(File path) {
        Assertions.assertTrue(path.isFile(), "Path must be a file: " + path.getAbsolutePath());
        Assertions.assertTrue(FS.isTestingDir(path.getParentFile()), "Can only delete content within the /target/tests/ directory: " + path.getAbsolutePath());
        Assertions.assertTrue(path.delete(), "Failed to delete file: " + path.getAbsolutePath());
    }

    public static void deleteFile(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            Assertions.assertTrue(Files.isRegularFile(path, new LinkOption[0]) || Files.isSymbolicLink(path), "Path must be a file or link: " + location);
            Assertions.assertTrue(FS.isTestingDir(path.getParent()), "Can only delete content within the /target/tests/ directory: " + location);
            try {
                Assertions.assertTrue(Files.deleteIfExists(path), "Failed to delete file: " + location);
            }
            catch (IOException e) {
                Assertions.fail("Unable to delete file: " + location, e);
            }
        }
    }

    public static void deleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            Assertions.assertTrue(Files.isDirectory(path, new LinkOption[0]), "Path must be a file: " + location);
            Assertions.assertTrue(FS.isTestingDir(path.getParent()), "Can only delete content within the /target/tests/ directory: " + location);
            try {
                Assertions.assertTrue(Files.deleteIfExists(path), "Failed to delete directory: " + location);
            }
            catch (IOException e) {
                Assertions.fail("Unable to delete directory: " + location, e);
            }
        }
    }

    private static void recursiveDeleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        Assertions.assertTrue(FS.isTestingDir(path), "Can only delete content within the /target/tests/ directory: " + location);
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
            for (Path entry : dir) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    FS.recursiveDeleteDir(entry);
                    continue;
                }
                FS.deleteFile(entry);
            }
        }
        catch (DirectoryIteratorException e) {
            Assertions.fail("Unable to (recursively) delete path: " + location, e);
        }
        catch (IOException e) {
            Assertions.fail("Unable to (recursively) delete path: " + location, e);
        }
        FS.deleteDir(path);
    }

    public static void cleanDirectory(File dir) {
        FS.cleanDirectory(dir.toPath());
    }

    public static void cleanDirectory(Path dir) {
        FS.deleteDirectory(dir);
        FS.ensureDirExists(dir);
    }

    public static void ensureEmpty(File dir) {
        FS.ensureEmpty(dir.toPath());
    }

    public static void ensureEmpty(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.cleanDirectory(dir);
        } else {
            FS.ensureDirExists(dir);
        }
    }

    public static void ensureDeleted(File dir) {
        FS.ensureDeleted(dir.toPath());
    }

    public static void ensureDeleted(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.deleteDirectory(dir);
        }
    }

    public static void ensureDirExists(File dir) {
        if (dir.exists()) {
            Assertions.assertTrue(dir.isDirectory(), "Path exists, but should be a Dir : " + dir.getAbsolutePath());
        } else {
            Assertions.assertTrue(dir.mkdirs(), "Creating dir: " + dir);
        }
    }

    public static void ensureDirExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            Assertions.assertTrue(Files.isDirectory(dir, new LinkOption[0]), "Path exists, but should be a Dir : " + dir.toAbsolutePath());
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Assertions.assertTrue(Files.exists(dir, new LinkOption[0]), "Failed to create dir: " + dir);
            }
            catch (IOException e) {
                Assertions.fail("Failed to create directory: " + dir, e);
            }
        }
    }

    protected static boolean isTestingDir(File dir) {
        return FS.isTestingDir(dir.toPath());
    }

    protected static boolean isTestingDir(Path dir) {
        try {
            return dir.toRealPath(new LinkOption[0]).startsWith(MavenTestingUtils.getTargetTestingPath());
        }
        catch (IOException e) {
            return dir.toAbsolutePath().startsWith(MavenTestingUtils.getTargetTestingPath());
        }
    }

    public static void touch(File file) throws IOException {
        if (file.exists()) {
            Assertions.assertTrue(file.setLastModified(System.currentTimeMillis()), "Updating last modified timestamp");
        } else {
            Assertions.assertTrue(file.createNewFile(), "Creating file: " + file);
        }
    }

    public static void touch(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            FileTime timeOrig = Files.getLastModifiedTime(file, new LinkOption[0]);
            Files.setLastModifiedTime(file, FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            FileTime timeNow = Files.getLastModifiedTime(file, new LinkOption[0]);
            MatcherAssert.assertThat("Timestamp updated", timeOrig, CoreMatchers.not(CoreMatchers.equalTo(timeNow)));
        } else {
            Files.createFile(file, new FileAttribute[0]);
            Assertions.assertTrue(Files.exists(file, new LinkOption[0]), "Created new file?: " + file);
        }
    }

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

