/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;

public class RewriteRegexRule
extends RegexRule
implements Rule.ApplyURI {
    private String _replacement;
    private String _query;

    public RewriteRegexRule() {
        this._handling = false;
        this._terminating = false;
    }

    public void setReplacement(String replacement) {
        String[] split = replacement.split("\\?", 2);
        this._replacement = split[0];
        this._query = split.length == 2 ? split[1] : null;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response, Matcher matcher) throws IOException {
        target = this._replacement;
        String query = this._query;
        for (int g = 1; g <= matcher.groupCount(); ++g) {
            String group = matcher.group(g);
            group = group == null ? "" : Matcher.quoteReplacement(group);
            target = target.replaceAll("\\$" + g, group);
            if (query == null) continue;
            query = query.replaceAll("\\$" + g, group);
        }
        if (query != null) {
            request.setAttribute("org.eclipse.jetty.rewrite.handler.RewriteRegexRule.Q", (Object)query);
        }
        return target;
    }

    @Override
    public void applyURI(Request request, String oldTarget, String newTarget) throws IOException {
        request.setRequestURI(newTarget);
        if (this._query != null) {
            String query = (String)request.getAttribute("org.eclipse.jetty.rewrite.handler.RewriteRegexRule.Q");
            if (request.getQueryString() == null) {
                request.setQueryString(query);
            } else {
                request.setQueryString(request.getQueryString() + "&" + query);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._replacement + "]";
    }
}

