/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpExchange {
    static final Logger LOG = Log.getLogger(HttpExchange.class);
    public static final int STATUS_START = 0;
    public static final int STATUS_WAITING_FOR_CONNECTION = 1;
    public static final int STATUS_WAITING_FOR_COMMIT = 2;
    public static final int STATUS_SENDING_REQUEST = 3;
    public static final int STATUS_WAITING_FOR_RESPONSE = 4;
    public static final int STATUS_PARSING_HEADERS = 5;
    public static final int STATUS_PARSING_CONTENT = 6;
    public static final int STATUS_COMPLETED = 7;
    public static final int STATUS_EXPIRED = 8;
    public static final int STATUS_EXCEPTED = 9;
    public static final int STATUS_CANCELLING = 10;
    public static final int STATUS_CANCELLED = 11;
    private String _method = "GET";
    private Buffer _scheme = HttpSchemes.HTTP_BUFFER;
    private String _uri;
    private int _version = 11;
    private Address _address;
    private final HttpFields _requestFields = new HttpFields();
    private Buffer _requestContent;
    private InputStream _requestContentSource;
    private AtomicInteger _status = new AtomicInteger(0);
    private boolean _retryStatus = false;
    private boolean _configureListeners = true;
    private HttpEventListener _listener = new Listener();
    private volatile AbstractHttpConnection _connection;
    private Address _localAddress = null;
    private long _timeout = -1L;
    private volatile Timeout.Task _timeoutTask;
    private long _lastStateChange = System.currentTimeMillis();
    private long _sent = -1L;
    private int _lastState = -1;
    private int _lastStatePeriod = -1;
    boolean _onRequestCompleteDone;
    boolean _onResponseCompleteDone;
    boolean _onDone;

    protected void expire(HttpDestination destination) {
        if (this.getStatus() < 7) {
            this.setStatus(8);
        }
        destination.exchangeExpired(this);
        AbstractHttpConnection connection = this._connection;
        if (connection != null) {
            connection.exchangeExpired(this);
        }
    }

    public int getStatus() {
        return this._status.get();
    }

    @Deprecated
    public void waitForStatus(int status) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForDone() throws InterruptedException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            while (!this.isDone()) {
                this.wait();
            }
            return this._status.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this._timeoutTask = null;
            this._onRequestCompleteDone = false;
            this._onResponseCompleteDone = false;
            this._onDone = false;
            this.setStatus(0);
        }
    }

    boolean setStatus(int newStatus) {
        boolean set = false;
        try {
            int oldStatus = this._status.get();
            boolean ignored = false;
            if (oldStatus != newStatus) {
                long now = System.currentTimeMillis();
                this._lastStatePeriod = (int)(now - this._lastStateChange);
                this._lastState = oldStatus;
                this._lastStateChange = now;
                if (newStatus == 3) {
                    this._sent = this._lastStateChange;
                }
            }
            block1 : switch (oldStatus) {
                case 0: {
                    switch (newStatus) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (newStatus) {
                        case 2: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (newStatus) {
                        case 3: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (newStatus) {
                        case 4: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onRequestCommitted();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (newStatus) {
                        case 5: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (newStatus) {
                        case 6: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onResponseHeaderComplete();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 6: {
                    switch (newStatus) {
                        case 7: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onResponseComplete();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this.setStatusExpired(newStatus, oldStatus);
                        }
                    }
                    break;
                }
                case 7: {
                    switch (newStatus) {
                        case 0: 
                        case 4: 
                        case 9: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: 
                        case 10: {
                            ignored = true;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (newStatus) {
                        case 9: 
                        case 11: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break block1;
                            this.done();
                            break;
                        }
                        default: {
                            ignored = true;
                            break;
                        }
                    }
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    switch (newStatus) {
                        case 0: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break block1;
                        }
                        case 7: {
                            ignored = true;
                            this.done();
                            break block1;
                        }
                    }
                    ignored = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)(oldStatus + " => " + newStatus));
                }
            }
            if (!set && !ignored) {
                throw new IllegalStateException(HttpExchange.toState(oldStatus) + " => " + HttpExchange.toState(newStatus));
            }
            LOG.debug("setStatus {} {}", newStatus, this);
        }
        catch (IOException x) {
            LOG.warn(x);
        }
        return set;
    }

    private boolean setStatusExpired(int newStatus, int oldStatus) {
        boolean set = this._status.compareAndSet(oldStatus, newStatus);
        if (set) {
            this.getEventListener().onExpire();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._onDone;
        }
    }

    @Deprecated
    public boolean isDone(int status) {
        return this.isDone();
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setURL(String url) {
        this.setURI(URI.create(url));
    }

    public void setAddress(Address address) {
        this._address = address;
    }

    public Address getAddress() {
        return this._address;
    }

    public Address getLocalAddress() {
        return this._localAddress;
    }

    public void setScheme(Buffer scheme) {
        this._scheme = scheme;
    }

    public void setScheme(String scheme) {
        if (scheme != null) {
            if ("http".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTP_BUFFER);
            } else if ("https".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTPS_BUFFER);
            } else {
                this.setScheme(new ByteArrayBuffer(scheme));
            }
        }
    }

    public Buffer getScheme() {
        return this._scheme;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void setVersion(String version) {
        BufferCache.CachedBuffer v = HttpVersions.CACHE.get(version);
        this._version = v == null ? 10 : v.getOrdinal();
    }

    public int getVersion() {
        return this._version;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    @Deprecated
    public String getURI() {
        return this.getRequestURI();
    }

    public String getRequestURI() {
        return this._uri;
    }

    @Deprecated
    public void setURI(String uri) {
        this.setRequestURI(uri);
    }

    public void setRequestURI(String uri) {
        this._uri = uri;
    }

    public void setURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("!Absolute URI: " + uri);
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("Opaque URI: " + uri);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("URI = {}", uri.toASCIIString());
        }
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (port <= 0) {
            port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        this.setScheme(scheme);
        this.setAddress(new Address(uri.getHost(), port));
        HttpURI httpUri = new HttpURI(uri);
        String completePath = httpUri.getCompletePath();
        this.setRequestURI(completePath == null ? "/" : completePath);
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestFields().add(name, value);
    }

    public void addRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().add(name, value);
    }

    public void setRequestHeader(String name, String value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestContentType(String value) {
        this.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, value);
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public void setRequestContent(Buffer requestContent) {
        this._requestContent = requestContent;
    }

    public void setRequestContentSource(InputStream stream) {
        this._requestContentSource = stream;
        if (this._requestContentSource != null && this._requestContentSource.markSupported()) {
            this._requestContentSource.mark(Integer.MAX_VALUE);
        }
    }

    public InputStream getRequestContentSource() {
        return this._requestContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getRequestContentChunk(Buffer buffer) throws IOException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._requestContentSource != null) {
                if (buffer == null) {
                    buffer = new ByteArrayBuffer(8192);
                }
                int space = buffer.space();
                int length = this._requestContentSource.read(buffer.array(), buffer.putIndex(), space);
                if (length >= 0) {
                    buffer.setPutIndex(buffer.putIndex() + length);
                    return buffer;
                }
            }
            return null;
        }
    }

    public Buffer getRequestContent() {
        return this._requestContent;
    }

    public boolean getRetryStatus() {
        return this._retryStatus;
    }

    public void setRetryStatus(boolean retryStatus) {
        this._retryStatus = retryStatus;
    }

    public void cancel() {
        this.setStatus(10);
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this.disassociate();
            this._onDone = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort() {
        AbstractHttpConnection httpConnection = this._connection;
        if (httpConnection != null) {
            try {
                httpConnection.close();
            }
            catch (IOException x) {
                LOG.debug(x);
            }
            finally {
                this.disassociate();
            }
        }
    }

    void associate(AbstractHttpConnection connection) {
        if (connection.getEndPoint().getLocalAddr() != null) {
            this._localAddress = new Address(connection.getEndPoint().getLocalAddr(), connection.getEndPoint().getLocalPort());
        }
        this._connection = connection;
        if (this.getStatus() == 10) {
            this.abort();
        }
    }

    boolean isAssociated() {
        return this._connection != null;
    }

    AbstractHttpConnection disassociate() {
        AbstractHttpConnection result = this._connection;
        this._connection = null;
        if (this.getStatus() == 10) {
            this.setStatus(11);
        }
        return result;
    }

    public static String toState(int s) {
        String state;
        switch (s) {
            case 0: {
                state = "START";
                break;
            }
            case 1: {
                state = "CONNECTING";
                break;
            }
            case 2: {
                state = "CONNECTED";
                break;
            }
            case 3: {
                state = "SENDING";
                break;
            }
            case 4: {
                state = "WAITING";
                break;
            }
            case 5: {
                state = "HEADERS";
                break;
            }
            case 6: {
                state = "CONTENT";
                break;
            }
            case 7: {
                state = "COMPLETED";
                break;
            }
            case 8: {
                state = "EXPIRED";
                break;
            }
            case 9: {
                state = "EXCEPTED";
                break;
            }
            case 10: {
                state = "CANCELLING";
                break;
            }
            case 11: {
                state = "CANCELLED";
                break;
            }
            default: {
                state = "UNKNOWN";
            }
        }
        return state;
    }

    public String toString() {
        String s;
        String state = HttpExchange.toState(this.getStatus());
        long now = System.currentTimeMillis();
        long forMs = now - this._lastStateChange;
        String string = s = this._lastState >= 0 ? String.format("%s@%x=%s//%s%s#%s(%dms)->%s(%dms)", this.getClass().getSimpleName(), this.hashCode(), this._method, this._address, this._uri, HttpExchange.toState(this._lastState), this._lastStatePeriod, state, forMs) : String.format("%s@%x=%s//%s%s#%s(%dms)", this.getClass().getSimpleName(), this.hashCode(), this._method, this._address, this._uri, state, forMs);
        if (this.getStatus() >= 3 && this._sent > 0L) {
            s = s + "sent=" + (now - this._sent) + "ms";
        }
        return s;
    }

    protected Connection onSwitchProtocol(EndPoint endp) throws IOException {
        return null;
    }

    protected void onRequestCommitted() throws IOException {
    }

    protected void onRequestComplete() throws IOException {
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
    }

    protected void onResponseHeaderComplete() throws IOException {
    }

    protected void onResponseContent(Buffer content) throws IOException {
    }

    protected void onResponseComplete() throws IOException {
    }

    protected void onConnectionFailed(Throwable x) {
        LOG.warn("CONNECTION FAILED " + this, x);
    }

    protected void onException(Throwable x) {
        LOG.warn("EXCEPTION " + this, x);
    }

    protected void onExpire() {
        LOG.warn("EXPIRED " + this, new Object[0]);
    }

    protected void onRetry() throws IOException {
        if (this._requestContentSource != null) {
            if (this._requestContentSource.markSupported()) {
                this._requestContent = null;
                this._requestContentSource.reset();
            } else {
                throw new IOException("Unsupported retry attempt");
            }
        }
    }

    public boolean configureListeners() {
        return this._configureListeners;
    }

    public void setConfigureListeners(boolean autoConfigure) {
        this._configureListeners = autoConfigure;
    }

    protected void scheduleTimeout(final HttpDestination destination) {
        assert (this._timeoutTask == null);
        this._timeoutTask = new Timeout.Task(){

            @Override
            public void expired() {
                HttpExchange.this.expire(destination);
            }
        };
        HttpClient httpClient = destination.getHttpClient();
        long timeout = this.getTimeout();
        if (timeout > 0L) {
            httpClient.schedule(this._timeoutTask, timeout);
        } else {
            httpClient.schedule(this._timeoutTask);
        }
    }

    protected void cancelTimeout(HttpClient httpClient) {
        Timeout.Task task = this._timeoutTask;
        if (task != null) {
            httpClient.cancel(task);
        }
        this._timeoutTask = null;
    }

    @Deprecated
    public static class ContentExchange
    extends org.eclipse.jetty.client.ContentExchange {
    }

    @Deprecated
    public static class CachedExchange
    extends org.eclipse.jetty.client.CachedExchange {
        public CachedExchange(boolean cacheFields) {
            super(cacheFields);
        }
    }

    private class Listener
    implements HttpEventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(Throwable ex) {
            try {
                HttpExchange.this.onConnectionFailed(ex);
            }
            finally {
                HttpExchange.this.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Throwable ex) {
            try {
                HttpExchange.this.onException(ex);
            }
            finally {
                HttpExchange.this.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExpire() {
            try {
                HttpExchange.this.onExpire();
            }
            finally {
                HttpExchange.this.done();
            }
        }

        @Override
        public void onRequestCommitted() throws IOException {
            HttpExchange.this.onRequestCommitted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestComplete() throws IOException {
            try {
                HttpExchange.this.onRequestComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onRequestCompleteDone = true;
                    HttpExchange.this._onDone |= HttpExchange.this._onResponseCompleteDone;
                    if (HttpExchange.this._onDone) {
                        HttpExchange.this.disassociate();
                    }
                    HttpExchange.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponseComplete() throws IOException {
            try {
                HttpExchange.this.onResponseComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onResponseCompleteDone = true;
                    HttpExchange.this._onDone |= HttpExchange.this._onRequestCompleteDone;
                    if (HttpExchange.this._onDone) {
                        HttpExchange.this.disassociate();
                    }
                    HttpExchange.this.notifyAll();
                }
            }
        }

        @Override
        public void onResponseContent(Buffer content) throws IOException {
            HttpExchange.this.onResponseContent(content);
        }

        @Override
        public void onResponseHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange.this.onResponseHeader(name, value);
        }

        @Override
        public void onResponseHeaderComplete() throws IOException {
            HttpExchange.this.onResponseHeaderComplete();
        }

        @Override
        public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange.this.onResponseStatus(version, status, reason);
        }

        @Override
        public void onRetry() {
            HttpExchange.this.setRetryStatus(true);
            try {
                HttpExchange.this.onRetry();
            }
            catch (IOException e) {
                LOG.debug(e);
            }
        }
    }
}

