/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.AsyncHttpConnection;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Timeout;

class SelectConnector
extends AggregateLifeCycle
implements HttpClient.Connector,
Dumpable {
    private static final Logger LOG = Log.getLogger(SelectConnector.class);
    private final HttpClient _httpClient;
    private final Manager _selectorManager = new Manager();
    private final Map<SocketChannel, Timeout.Task> _connectingChannels = new ConcurrentHashMap<SocketChannel, Timeout.Task>();

    SelectConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
        this.addBean(this._httpClient, false);
        this.addBean(this._selectorManager, true);
    }

    @Override
    public void startConnection(HttpDestination destination) throws IOException {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
            channel.socket().setTcpNoDelay(true);
            if (this._httpClient.isConnectBlocking()) {
                channel.socket().connect(address.toSocketAddress(), this._httpClient.getConnectTimeout());
                channel.configureBlocking(false);
                this._selectorManager.register(channel, destination);
            } else {
                channel.configureBlocking(false);
                channel.connect(address.toSocketAddress());
                this._selectorManager.register(channel, destination);
                ConnectTimeout connectTimeout = new ConnectTimeout(channel, destination);
                this._httpClient.schedule(connectTimeout, this._httpClient.getConnectTimeout());
                this._connectingChannels.put(channel, connectTimeout);
            }
        }
        catch (UnresolvedAddressException ex) {
            if (channel != null) {
                channel.close();
            }
            destination.onConnectionFailed(ex);
        }
        catch (IOException ex) {
            if (channel != null) {
                channel.close();
            }
            destination.onConnectionFailed(ex);
        }
    }

    public static class UpgradableEndPoint
    implements AsyncEndPoint {
        AsyncEndPoint _endp;
        SSLEngine _engine;

        public UpgradableEndPoint(AsyncEndPoint endp, SSLEngine engine) throws IOException {
            this._engine = engine;
            this._endp = endp;
        }

        public void upgrade() {
            AsyncHttpConnection connection = (AsyncHttpConnection)this._endp.getConnection();
            SslConnection sslConnection = new SslConnection(this._engine, this._endp);
            this._endp.setConnection(sslConnection);
            this._endp = sslConnection.getSslEndPoint();
            sslConnection.getSslEndPoint().setConnection(connection);
            LOG.debug("upgrade {} to {} for {}", this, sslConnection, connection);
        }

        @Override
        public Connection getConnection() {
            return this._endp.getConnection();
        }

        @Override
        public void setConnection(Connection connection) {
            this._endp.setConnection(connection);
        }

        @Override
        public void shutdownOutput() throws IOException {
            this._endp.shutdownOutput();
        }

        @Override
        public void asyncDispatch() {
            this._endp.asyncDispatch();
        }

        @Override
        public boolean isOutputShutdown() {
            return this._endp.isOutputShutdown();
        }

        @Override
        public void shutdownInput() throws IOException {
            this._endp.shutdownInput();
        }

        @Override
        public void scheduleWrite() {
            this._endp.scheduleWrite();
        }

        @Override
        public boolean isInputShutdown() {
            return this._endp.isInputShutdown();
        }

        @Override
        public void close() throws IOException {
            this._endp.close();
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            return this._endp.fill(buffer);
        }

        @Override
        public boolean isWritable() {
            return this._endp.isWritable();
        }

        @Override
        public boolean hasProgressed() {
            return this._endp.hasProgressed();
        }

        @Override
        public int flush(Buffer buffer) throws IOException {
            return this._endp.flush(buffer);
        }

        @Override
        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            this._endp.scheduleTimeout(task, timeoutMs);
        }

        @Override
        public void cancelTimeout(Timeout.Task task) {
            this._endp.cancelTimeout(task);
        }

        @Override
        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            return this._endp.flush(header, buffer, trailer);
        }

        @Override
        public String getLocalAddr() {
            return this._endp.getLocalAddr();
        }

        @Override
        public String getLocalHost() {
            return this._endp.getLocalHost();
        }

        @Override
        public int getLocalPort() {
            return this._endp.getLocalPort();
        }

        @Override
        public String getRemoteAddr() {
            return this._endp.getRemoteAddr();
        }

        @Override
        public String getRemoteHost() {
            return this._endp.getRemoteHost();
        }

        @Override
        public int getRemotePort() {
            return this._endp.getRemotePort();
        }

        @Override
        public boolean isBlocking() {
            return this._endp.isBlocking();
        }

        @Override
        public boolean blockReadable(long millisecs) throws IOException {
            return this._endp.blockReadable(millisecs);
        }

        @Override
        public boolean blockWritable(long millisecs) throws IOException {
            return this._endp.blockWritable(millisecs);
        }

        @Override
        public boolean isOpen() {
            return this._endp.isOpen();
        }

        @Override
        public Object getTransport() {
            return this._endp.getTransport();
        }

        @Override
        public void flush() throws IOException {
            this._endp.flush();
        }

        @Override
        public int getMaxIdleTime() {
            return this._endp.getMaxIdleTime();
        }

        @Override
        public void setMaxIdleTime(int timeMs) throws IOException {
            this._endp.setMaxIdleTime(timeMs);
        }

        @Override
        public void onIdleExpired(long idleForMs) {
            this._endp.onIdleExpired(idleForMs);
        }

        @Override
        public void setCheckForIdle(boolean check) {
            this._endp.setCheckForIdle(check);
        }

        @Override
        public boolean isCheckForIdle() {
            return this._endp.isCheckForIdle();
        }

        public String toString() {
            return "Upgradable:" + this._endp.toString();
        }
    }

    private class ConnectTimeout
    extends Timeout.Task {
        private final SocketChannel channel;
        private final HttpDestination destination;

        public ConnectTimeout(SocketChannel channel, HttpDestination destination) {
            this.channel = channel;
            this.destination = destination;
        }

        @Override
        public void expired() {
            if (this.channel.isConnectionPending()) {
                LOG.debug("Channel {} timed out while connecting, closing it", this.channel);
                try {
                    this.channel.close();
                }
                catch (IOException x) {
                    LOG.ignore(x);
                }
                this.destination.onConnectionFailed(new SocketTimeoutException());
            }
        }
    }

    class Manager
    extends SelectorManager {
        Logger LOG = SelectConnector.access$000();

        Manager() {
        }

        @Override
        public boolean dispatch(Runnable task) {
            return ((SelectConnector)SelectConnector.this)._httpClient._threadPool.dispatch(task);
        }

        @Override
        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
        }

        @Override
        public AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint, Object attachment) {
            return new AsyncHttpConnection(SelectConnector.this._httpClient.getRequestBuffers(), SelectConnector.this._httpClient.getResponseBuffers(), endpoint);
        }

        @Override
        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            SelectChannelEndPoint scep;
            Timeout.Task connectTimeout = (Timeout.Task)SelectConnector.this._connectingChannels.remove(channel);
            if (connectTimeout != null) {
                connectTimeout.cancel();
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Channels with connection pending: {}", SelectConnector.this._connectingChannels.size());
            }
            HttpDestination dest = (HttpDestination)key.attachment();
            AsyncEndPoint ep = scep = new SelectChannelEndPoint(channel, selectSet, key, (int)SelectConnector.this._httpClient.getIdleTimeout());
            if (dest.isSecure()) {
                this.LOG.debug("secure to {}, proxied={}", channel, dest.isProxied());
                ep = new UpgradableEndPoint(ep, this.newSslEngine(channel));
            }
            AsyncConnection connection = selectSet.getManager().newConnection(channel, ep, key.attachment());
            ep.setConnection(connection);
            AbstractHttpConnection httpConnection = (AbstractHttpConnection)((Object)connection);
            httpConnection.setDestination(dest);
            if (dest.isSecure() && !dest.isProxied()) {
                ((UpgradableEndPoint)ep).upgrade();
            }
            dest.onNewConnection(httpConnection);
            return scep;
        }

        private synchronized SSLEngine newSslEngine(SocketChannel channel) throws IOException {
            SSLEngine sslEngine;
            SslContextFactory sslContextFactory = SelectConnector.this._httpClient.getSslContextFactory();
            if (channel != null) {
                String peerHost = channel.socket().getInetAddress().getHostAddress();
                int peerPort = channel.socket().getPort();
                sslEngine = sslContextFactory.newSslEngine(peerHost, peerPort);
            } else {
                sslEngine = sslContextFactory.newSslEngine();
            }
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            return sslEngine;
        }

        @Override
        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            Timeout.Task connectTimeout = (Timeout.Task)SelectConnector.this._connectingChannels.remove(channel);
            if (connectTimeout != null) {
                connectTimeout.cancel();
            }
            if (attachment instanceof HttpDestination) {
                ((HttpDestination)attachment).onConnectionFailed(ex);
            } else {
                super.connectionFailed(channel, ex, attachment);
            }
        }
    }
}

