/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class MonitoredDirAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private boolean _acceptContextXmlFiles = true;
    private boolean _acceptWarFiles = true;
    private boolean _acceptDirectories = true;
    private Resource _monitoredDir;
    private Scanner _scanner;
    private int _scanInterval = 10;
    private boolean _recursive = false;
    private boolean _extractWars = false;
    private boolean _parentLoaderPriority = false;
    private String _defaultsDescriptor;
    private DeploymentManager _deploymentManager;
    private FilenameFilter _filenamefilter;
    private ConfigurationManager _configurationManager;
    private final Scanner.DiscreteListener _scannerListener = new Scanner.DiscreteListener(){

        public void fileAdded(String filename) throws Exception {
            if (Log.isDebugEnabled()) {
                Log.debug("added ", filename);
            }
            MonitoredDirAppProvider.this.addConfiguredContextApp(filename);
        }

        public void fileChanged(String filename) throws Exception {
            System.err.println("changed " + filename);
            if (Log.isDebugEnabled()) {
                Log.debug("changed ", filename);
            }
            MonitoredDirAppProvider.this.addConfiguredContextApp(filename);
        }

        public void fileRemoved(String filename) throws Exception {
            if (Log.isDebugEnabled()) {
                Log.debug("removed ", filename);
            }
        }
    };

    public MonitoredDirAppProvider() {
        this._filenamefilter = new MonitoredFilenameFilter();
    }

    protected MonitoredDirAppProvider(boolean xml, boolean war, boolean dir) {
        this._acceptContextXmlFiles = xml;
        this._acceptWarFiles = war;
        this._acceptDirectories = dir;
        this._filenamefilter = new MonitoredFilenameFilter();
    }

    protected MonitoredDirAppProvider(FilenameFilter filter, boolean xml, boolean war, boolean dir) {
        this._acceptContextXmlFiles = xml;
        this._acceptWarFiles = war;
        this._acceptDirectories = dir;
        this._filenamefilter = filter;
    }

    private App addConfiguredContextApp(String filename) {
        App app = new App(this._deploymentManager, this, filename);
        this._deploymentManager.addApp(app);
        return app;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource(app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resouce does not exist " + resource);
        }
        if (this._acceptContextXmlFiles && FileID.isXmlFile(file)) {
            XmlConfiguration xmlc = new XmlConfiguration(resource.getURL());
            HashMap<String, Server> props = new HashMap<String, Server>();
            props.put("Server", this._deploymentManager.getServer());
            if (this.getConfigurationManager() != null) {
                props.putAll(this.getConfigurationManager().getProperties());
            }
            xmlc.setProperties(props);
            return (ContextHandler)xmlc.configure();
        }
        String context = file.getName();
        if (this._acceptWarFiles && FileID.isWebArchiveFile(file)) {
            context = context.substring(0, context.length() - 4);
        } else if (!this._acceptDirectories || !file.isDirectory()) {
            throw new IllegalStateException("unable to create ContextHandler for " + app);
        }
        if (context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/")) {
            context = "/";
        }
        if (context.charAt(0) != '/') {
            context = "/" + context;
        }
        if (context.endsWith("/") && context.length() > 0) {
            context = context.substring(0, context.length() - 1);
        }
        WebAppContext wah = new WebAppContext();
        wah.setContextPath(context);
        wah.setWar(file.getAbsolutePath());
        if (this._defaultsDescriptor != null) {
            wah.setDefaultsDescriptor(this._defaultsDescriptor);
        }
        wah.setExtractWAR(this._extractWars);
        wah.setParentLoaderPriority(this._parentLoaderPriority);
        return wah;
    }

    protected void doStart() throws Exception {
        if (this._monitoredDir == null) {
            throw new IllegalStateException("No configuration dir specified");
        }
        File scandir = this._monitoredDir.getFile();
        Log.info("Deployment monitor " + scandir + " at interval " + this._scanInterval);
        this._scanner = new Scanner();
        this._scanner.setScanDirs(Collections.singletonList(scandir));
        this._scanner.setScanInterval(this._scanInterval);
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(this._filenamefilter);
        this._scanner.setReportDirs(this._acceptDirectories);
        this._scanner.addListener(this._scannerListener);
        this._scanner.start();
    }

    protected void doStop() throws Exception {
        this._scanner.stop();
        this._scanner.removeListener(this._scannerListener);
        this._scanner = null;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Resource getMonitoredDir() {
        return this._monitoredDir;
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public boolean isAcceptContextXmlFiles() {
        return this._acceptContextXmlFiles;
    }

    public boolean isAcceptDirectories() {
        return this._acceptDirectories;
    }

    public boolean isAcceptWarFiles() {
        return this._acceptWarFiles;
    }

    public boolean isExtractWars() {
        return this._extractWars;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setAcceptContextXmlFiles(boolean flag) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._acceptContextXmlFiles = flag;
    }

    public void setAcceptDirectories(boolean flag) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._acceptDirectories = flag;
    }

    public void setAcceptWarFiles(boolean flag) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._acceptWarFiles = flag;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configurationManager = configurationManager;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public void setExtractWars(boolean extractWars) {
        this._extractWars = extractWars;
    }

    public void setMonitoredDir(Resource contextsDir) {
        this._monitoredDir = contextsDir;
    }

    public void setMonitoredDir(String dir) {
        try {
            this._monitoredDir = Resource.newResource(dir);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }

    class MonitoredFilenameFilter
    implements FilenameFilter {
        MonitoredFilenameFilter() {
        }

        public boolean accept(File file, String name) {
            if (!file.exists()) {
                return false;
            }
            String lowername = name.toLowerCase();
            if (MonitoredDirAppProvider.this._acceptContextXmlFiles && !file.isDirectory() && lowername.endsWith(".xml")) {
                return true;
            }
            if (MonitoredDirAppProvider.this._acceptWarFiles && !file.isDirectory() && lowername.endsWith(".war")) {
                return true;
            }
            return MonitoredDirAppProvider.this._acceptDirectories && file.isDirectory();
        }
    }
}

