/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ImmutableLongShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortLongMap;
import org.eclipse.collections.api.map.primitive.LongShortMap;
import org.eclipse.collections.api.map.primitive.MutableLongShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.LongShortPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongShortProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.factory.primitive.ShortLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

final class ImmutableLongShortHashMap
implements ImmutableLongShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongShortMap delegate;

    ImmutableLongShortHashMap(LongShortMap delegate) {
        this.delegate = new LongShortHashMap(delegate);
    }

    public short get(long key) {
        return this.delegate.get(key);
    }

    public short getIfAbsent(long key, short ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongShortProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongShortPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableShortLongMap flipUniqueValues() {
        MutableShortLongMap result = ShortLongMaps.mutable.empty();
        this.forEachKeyValue((LongShortProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableLongShortMap select(LongShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongShortMap reject(LongShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableShortIterator iterator = this.delegate.shortIterator();
            while (iterator.hasNext()) {
                MutableShortBag batch = ShortBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableLongShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.delegate.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortBag select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public short max() {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    public short[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList() {
        return this.delegate.toList();
    }

    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongShortMap newWithKeyValue(long key, short value) {
        LongShortHashMap map = new LongShortHashMap(this.size() + 1);
        map.putAll((LongShortMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongShortMap newWithoutKey(long key) {
        LongShortHashMap map = new LongShortHashMap(this.size());
        map.putAll((LongShortMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongShortMap newWithoutAllKeys(LongIterable keys) {
        LongShortHashMap map = new LongShortHashMap(this.size());
        map.putAll((LongShortMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongShortMapSerializationProxy((LongShortMap)this);
    }

    protected static class ImmutableLongShortMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongShortMap map;

        public ImmutableLongShortMapSerializationProxy() {
        }

        protected ImmutableLongShortMapSerializationProxy(LongShortMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongShortProcedure)new CheckedLongShortProcedure(){

                    @Override
                    public void safeValue(long key, short value) throws IOException {
                        out.writeLong(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongShortHashMap deserializedMap = new LongShortHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readShort());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

