/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.ordered.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.ImmutableOrderedMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.MutableOrderedMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.ordered.ReversibleIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.utility.LazyIterate;

public class UnmodifiableMutableOrderedMap<K, V>
implements MutableOrderedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableOrderedMap<K, V> delegate;

    public UnmodifiableMutableOrderedMap(MutableOrderedMap<K, V> delegate) {
        this.delegate = delegate;
    }

    public static <K, V> UnmodifiableMutableOrderedMap<K, V> of(MutableOrderedMap<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("cannot create a UnmodifiableMutableOrderedMap for null");
        }
        return new UnmodifiableMutableOrderedMap<K, V>(map);
    }

    public V put(K key, V value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this.delegate).entrySet();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    public MutableOrderedMap<K, V> withKeyValue(K key, V value) {
        throw new UnsupportedOperationException("Cannot call collectKeysAndValues() on " + this.getClass().getSimpleName());
    }

    public MutableOrderedMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        throw new UnsupportedOperationException("Cannot call withAllKeyValues() on " + this.getClass().getSimpleName());
    }

    public MutableOrderedMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        throw new UnsupportedOperationException("Cannot call withAllKeyValueArguments() on " + this.getClass().getSimpleName());
    }

    public MutableOrderedMap<K, V> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableOrderedMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public V removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        throw new UnsupportedOperationException("Cannot call updateValueWith() on " + this.getClass().getSimpleName());
    }

    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        V result = this.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot mutate " + this.getClass().getSimpleName());
        }
        return result;
    }

    public V getIfAbsentPut(K key, V value) {
        V result = this.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot mutate " + this.getClass().getSimpleName());
        }
        return result;
    }

    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        return this.getIfAbsentPutWith(key, function, key);
    }

    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        V result = this.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot mutate " + this.getClass().getSimpleName());
        }
        return result;
    }

    private boolean isAbsent(V result, K key) {
        return result == null && !this.containsKey(key);
    }

    public MutableMapIterable<K, V> asSynchronized() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asSynchronized() not implemented yet");
    }

    public MutableOrderedMap<K, V> asUnmodifiable() {
        return this;
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.delegate.iterator());
    }

    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return LazyIterate.adapt(this.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
    }

    public MutableOrderedMap<K, V> tap(Procedure<? super V> procedure) {
        return this.delegate.tap(procedure);
    }

    public MutableOrderedMap<V, K> flipUniqueValues() {
        return this.delegate.flipUniqueValues();
    }

    public MutableListMultimap<V, K> flip() {
        return this.delegate.flip();
    }

    public void forEach(Procedure<? super V> procedure) {
        this.delegate.forEach(procedure);
    }

    public void forEach(Consumer<? super V> consumer) {
        this.delegate.forEach(consumer);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.delegate.forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.delegate.forEachWith(procedure, parameter);
    }

    public MutableOrderedMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.select(predicate);
    }

    public MutableOrderedMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.reject(predicate);
    }

    public <K2, V2> MutableOrderedMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.delegate.collect(function);
    }

    public <R> MutableOrderedMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return this.delegate.collectValues(function);
    }

    public MutableOrderedMap<K, V> toReversed() {
        return this.delegate.toReversed();
    }

    public MutableOrderedMap<K, V> take(int count) {
        return this.delegate.take(count);
    }

    public MutableOrderedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        return this.delegate.takeWhile(predicate);
    }

    public MutableOrderedMap<K, V> drop(int count) {
        return this.delegate.drop(count);
    }

    public MutableOrderedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        return this.delegate.dropWhile(predicate);
    }

    public PartitionMutableList<V> partitionWhile(Predicate<? super V> predicate) {
        return this.delegate.partitionWhile(predicate);
    }

    public MutableList<V> distinct() {
        return this.delegate.distinct();
    }

    public MutableList<V> select(Predicate<? super V> predicate) {
        return this.delegate.select(predicate);
    }

    public <P> MutableList<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.selectWith(predicate, parameter);
    }

    public MutableList<V> reject(Predicate<? super V> predicate) {
        return this.delegate.reject(predicate);
    }

    public <P> MutableList<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.rejectWith(predicate, parameter);
    }

    public PartitionMutableList<V> partition(Predicate<? super V> predicate) {
        return this.delegate.partition(predicate);
    }

    public <P> PartitionMutableList<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.partitionWith(predicate, parameter);
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.delegate.collectBoolean(booleanFunction);
    }

    public MutableByteList collectByte(ByteFunction<? super V> byteFunction) {
        return this.delegate.collectByte(byteFunction);
    }

    public MutableCharList collectChar(CharFunction<? super V> charFunction) {
        return this.delegate.collectChar(charFunction);
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.delegate.collectDouble(doubleFunction);
    }

    public MutableFloatList collectFloat(FloatFunction<? super V> floatFunction) {
        return this.delegate.collectFloat(floatFunction);
    }

    public MutableIntList collectInt(IntFunction<? super V> intFunction) {
        return this.delegate.collectInt(intFunction);
    }

    public MutableLongList collectLong(LongFunction<? super V> longFunction) {
        return this.delegate.collectLong(longFunction);
    }

    public MutableShortList collectShort(ShortFunction<? super V> shortFunction) {
        return this.delegate.collectShort(shortFunction);
    }

    public <S> MutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.delegate.zip(that);
    }

    public MutableList<Pair<V, Integer>> zipWithIndex() {
        return this.delegate.zipWithIndex();
    }

    public <VV> MutableList<VV> collect(Function<? super V, ? extends VV> function) {
        return this.delegate.collect(function);
    }

    public <P, VV> MutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.delegate.collectWith(function, parameter);
    }

    public <VV> MutableList<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.delegate.collectIf(predicate, function);
    }

    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return this.delegate.selectInstancesOf(clazz);
    }

    public <VV> MutableList<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.flatCollect(function);
    }

    public <P, VV> MutableList<VV> flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<VV>> function, P parameter) {
        return this.delegate.flatCollectWith(function, parameter);
    }

    public <VV> MutableListMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.delegate.groupBy(function);
    }

    public <VV> MutableListMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.groupByEach(function);
    }

    public <VV> MutableOrderedMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.delegate.groupByUniqueKey(function);
    }

    public ImmutableOrderedMap<K, V> toImmutable() {
        return this.delegate.toImmutable();
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public V getIfAbsent(K key, Function0<? extends V> function) {
        return (V)this.delegate.getIfAbsent(key, function);
    }

    public V getIfAbsentValue(K key, V value) {
        return (V)this.delegate.getIfAbsentValue(key, value);
    }

    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        return (V)this.delegate.getIfAbsentWith(key, function, parameter);
    }

    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        return (A)this.delegate.ifPresentApply(key, function);
    }

    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.detect(predicate);
    }

    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.detectOptional(predicate);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public V getFirst() {
        return (V)this.delegate.getFirst();
    }

    public V getLast() {
        return (V)this.delegate.getLast();
    }

    public V getOnly() {
        return (V)this.delegate.getOnly();
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.delegate.containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.delegate.containsAllArguments(elements);
    }

    public void each(Procedure<? super V> procedure) {
        this.delegate.each(procedure);
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.select(predicate, target);
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.reject(predicate, target);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collect(function, target);
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return (R)this.delegate.collectBoolean(booleanFunction, target);
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return (R)this.delegate.collectByte(byteFunction, target);
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return (R)this.delegate.collectChar(charFunction, target);
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return (R)this.delegate.collectDouble(doubleFunction, target);
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return (R)this.delegate.collectFloat(floatFunction, target);
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return (R)this.delegate.collectInt(intFunction, target);
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return (R)this.delegate.collectLong(longFunction, target);
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return (R)this.delegate.collectShort(shortFunction, target);
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return (R)this.delegate.collectWith(function, parameter, targetCollection);
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collectIf(predicate, function, target);
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.flatCollect(function, target);
    }

    public <P, VV, R extends Collection<VV>> R flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<VV>> function, P parameter, R target) {
        return (R)this.delegate.flatCollectWith(function, parameter, target);
    }

    public V detect(Predicate<? super V> predicate) {
        return (V)this.delegate.detect(predicate);
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (V)this.delegate.detectWith(predicate, parameter);
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return this.delegate.detectOptional(predicate);
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.detectWithOptional(predicate, parameter);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.delegate.detectIfNone(predicate, function);
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)this.delegate.detectWithIfNone(predicate, parameter, function);
    }

    public int count(Predicate<? super V> predicate) {
        return this.delegate.count(predicate);
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.countWith(predicate, parameter);
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.anySatisfyWith(predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.allSatisfyWith(predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.noneSatisfyWith(predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)this.delegate.injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public <R extends Collection<V>> R into(R target) {
        return (R)this.delegate.into(target);
    }

    public MutableList<V> toList() {
        return this.delegate.toList();
    }

    public MutableList<V> toSortedList() {
        return this.delegate.toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.delegate.toSortedList(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedListBy(function);
    }

    public MutableSet<V> toSet() {
        return this.delegate.toSet();
    }

    public MutableSortedSet<V> toSortedSet() {
        return this.delegate.toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.delegate.toSortedSet(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedSetBy(function);
    }

    public MutableBag<V> toBag() {
        return this.delegate.toBag();
    }

    public MutableSortedBag<V> toSortedBag() {
        return this.delegate.toSortedBag();
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return this.delegate.toSortedBag(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedBagBy(function);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
    }

    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMapBy(sortBy, keyFunction, valueFunction);
    }

    public LazyIterable<V> asLazy() {
        return this.delegate.asLazy();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] target) {
        return this.delegate.toArray((Object[])target);
    }

    public V min(Comparator<? super V> comparator) {
        return (V)this.delegate.min(comparator);
    }

    public V max(Comparator<? super V> comparator) {
        return (V)this.delegate.max(comparator);
    }

    public Optional<V> minOptional(Comparator<? super V> comparator) {
        return this.delegate.minOptional(comparator);
    }

    public Optional<V> maxOptional(Comparator<? super V> comparator) {
        return this.delegate.maxOptional(comparator);
    }

    public V min() {
        return (V)this.delegate.min();
    }

    public V max() {
        return (V)this.delegate.max();
    }

    public Optional<V> minOptional() {
        return this.delegate.minOptional();
    }

    public Optional<V> maxOptional() {
        return this.delegate.maxOptional();
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.minBy(function);
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.maxBy(function);
    }

    public <VV extends Comparable<? super VV>> Optional<V> minByOptional(Function<? super V, ? extends VV> function) {
        return this.delegate.minByOptional(function);
    }

    public <VV extends Comparable<? super VV>> Optional<V> maxByOptional(Function<? super V, ? extends VV> function) {
        return this.delegate.maxByOptional(function);
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return this.delegate.sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.delegate.sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return this.delegate.sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.delegate.sumOfDouble(function);
    }

    public IntSummaryStatistics summarizeInt(IntFunction<? super V> function) {
        return this.delegate.summarizeInt(function);
    }

    public DoubleSummaryStatistics summarizeFloat(FloatFunction<? super V> function) {
        return this.delegate.summarizeFloat(function);
    }

    public LongSummaryStatistics summarizeLong(LongFunction<? super V> function) {
        return this.delegate.summarizeLong(function);
    }

    public DoubleSummaryStatistics summarizeDouble(DoubleFunction<? super V> function) {
        return this.delegate.summarizeDouble(function);
    }

    public <R, A> R reduceInPlace(Collector<? super V, A, R> collector) {
        return (R)this.delegate.reduceInPlace(collector);
    }

    public <R> R reduceInPlace(Supplier<R> supplier, BiConsumer<R, ? super V> accumulator) {
        return (R)this.delegate.reduceInPlace(supplier, accumulator);
    }

    public Optional<V> reduce(BinaryOperator<V> accumulator) {
        return this.delegate.reduce(accumulator);
    }

    public <VV> MutableObjectLongMap<VV> sumByInt(Function<? super V, ? extends VV> groupBy, IntFunction<? super V> function) {
        return this.delegate.sumByInt(groupBy, function);
    }

    public <VV> MutableObjectDoubleMap<VV> sumByFloat(Function<? super V, ? extends VV> groupBy, FloatFunction<? super V> function) {
        return this.delegate.sumByFloat(groupBy, function);
    }

    public <VV> MutableObjectLongMap<VV> sumByLong(Function<? super V, ? extends VV> groupBy, LongFunction<? super V> function) {
        return this.delegate.sumByLong(groupBy, function);
    }

    public <VV> MutableObjectDoubleMap<VV> sumByDouble(Function<? super V, ? extends VV> groupBy, DoubleFunction<? super V> function) {
        return this.delegate.sumByDouble(groupBy, function);
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public <VV> MutableBag<VV> countBy(Function<? super V, ? extends VV> function) {
        return this.delegate.countBy(function);
    }

    public <VV, R extends MutableBagIterable<VV>> R countBy(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.countBy(function, target);
    }

    public <VV, P> MutableBag<VV> countByWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.delegate.countByWith(function, parameter);
    }

    public <VV, P, R extends MutableBagIterable<VV>> R countByWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R target) {
        return (R)this.delegate.countByWith(function, parameter, target);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.groupBy(function, target);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.groupByEach(function, target);
    }

    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.groupByUniqueKey(function, target);
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.delegate.zip(that, target);
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return (R)this.delegate.zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.delegate.chunk(size);
    }

    public <KK, VV> MutableMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    public <KK, VV> MutableMap<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    public MutableMapIterable<K, V> newEmpty() {
        return this.delegate.newEmpty();
    }

    public void reverseForEach(Procedure<? super V> procedure) {
        this.delegate.reverseForEach(procedure);
    }

    public void reverseForEachWithIndex(ObjectIntProcedure<? super V> procedure) {
        this.delegate.reverseForEachWithIndex(procedure);
    }

    public int detectLastIndex(Predicate<? super V> predicate) {
        return this.delegate.detectLastIndex(predicate);
    }

    public <V1> ReversibleIterable<V1> collectWithIndex(ObjectIntToObjectFunction<? super V, ? extends V1> function) {
        return this.delegate.collectWithIndex(function);
    }

    public int indexOf(Object object) {
        return this.delegate.indexOf(object);
    }

    public Optional<V> getFirstOptional() {
        return this.delegate.getFirstOptional();
    }

    public Optional<V> getLastOptional() {
        return this.delegate.getLastOptional();
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super V, ? super S> predicate) {
        return this.delegate.corresponds(other, predicate);
    }

    public void forEach(int startIndex, int endIndex, Procedure<? super V> procedure) {
        this.delegate.forEach(startIndex, endIndex, procedure);
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super V> objectIntProcedure) {
        this.delegate.forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
    }

    public MutableStack<V> toStack() {
        return this.delegate.toStack();
    }

    public <VV, R extends Collection<VV>> R collectWithIndex(ObjectIntToObjectFunction<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collectWithIndex(function, target);
    }

    public int detectIndex(Predicate<? super V> predicate) {
        return this.delegate.detectIndex(predicate);
    }
}

