/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.ThrowingInvocationHandler;

public final class ServiceLoaderUtils {
    private ServiceLoaderUtils() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> T loadServiceClass(Class<T> serviceClass) {
        String message;
        ArrayList<T> factories = new ArrayList<T>();
        for (T factory : ServiceLoader.load(serviceClass)) {
            factories.add(factory);
        }
        if (factories.isEmpty()) {
            message = "Could not find any implementations of " + serviceClass.getSimpleName() + ". Check that eclipse-collections.jar is on the classpath and that its META-INF/services directory is intact.";
            return ServiceLoaderUtils.createProxyInstance(serviceClass, message);
        }
        if (factories.size() > 1) {
            message = String.format("Found multiple implementations of %s on the classpath. Check that there is only one copy of eclipse-collections.jar on the classpath. Found implementations: %s.", serviceClass.getSimpleName(), factories.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
            return ServiceLoaderUtils.createProxyInstance(serviceClass, message);
        }
        return (T)factories.get(0);
    }

    private static <T> T createProxyInstance(Class<T> serviceClass, String message) {
        ThrowingInvocationHandler handler = new ThrowingInvocationHandler(message);
        Object proxyInstance = Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler);
        return serviceClass.cast(proxyInstance);
    }
}

