/*
 * Copyright (c) 2018 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.map.primitive.MutableShortDoubleMap;
import org.eclipse.collections.api.map.primitive.ShortDoubleMap;

/**
 * A factory which creates instances of type {@link MutableShortDoubleMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableShortDoubleMapFactory
{
    MutableShortDoubleMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableShortDoubleMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableShortDoubleMap with();

    /**
     * Same as {@link #withAll(ShortDoubleMap)}.
     */
    MutableShortDoubleMap ofAll(ShortDoubleMap map);

    MutableShortDoubleMap withAll(ShortDoubleMap map);

    /**
     * Creates an {@code MutableShortDoubleMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> MutableShortDoubleMap from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction);
}
