/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.taglib.AbstractBaseTag;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;

public class RequesterTag
extends AbstractBaseTag {
    private static final long serialVersionUID = -4360776653926113953L;
    private Map parameters;
    private Boolean validated;

    @Override
    public void __init() {
        super.__init();
        this.parameters = new HashMap();
        this.validated = null;
    }

    @Override
    public int doStartTag() throws JspException {
        block6: {
            try {
                if (this.__validate()) {
                    if (this.viewer.isCustom()) {
                        String viewingSessionId = ViewingSessionUtil.createSession((HttpServletRequest)this.pageContext.getRequest()).getId();
                        JspWriter writer = this.pageContext.getOut();
                        writer.write("<DIV ");
                        if (this.viewer.getId() != null) {
                            writer.write(" ID=\"" + this.viewer.getId() + "\" ");
                        }
                        writer.write(this.__handleDivAppearance() + ">\n");
                        writer.write("<FORM NAME=\"" + this.viewer.getName() + "\" METHOD=\"post\" ");
                        writer.write(" action=\"" + this.viewer.createURI(null, viewingSessionId) + "\"");
                        if (this.viewer.getTarget() != null) {
                            writer.write(" target=\"" + this.viewer.getTarget() + "\"");
                        }
                        writer.write(">\n");
                    }
                    break block6;
                }
                return 0;
            }
            catch (Exception e) {
                this.__handleException(e);
                return 0;
            }
        }
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            if (!this.__validate()) {
                return 0;
            }
            this.__beforeEndTag();
            this.__process();
        }
        catch (Exception e) {
            this.__handleException(e);
            return 0;
        }
        return 6;
    }

    @Override
    public boolean __validate() throws Exception {
        if (this.validated != null) {
            return this.validated;
        }
        this.validated = Boolean.FALSE;
        Locale locale = BirtTagUtil.getLocale((HttpServletRequest)this.pageContext.getRequest(), this.viewer.getLocale());
        BirtResources.setLocale(locale);
        if (this.viewer.getId() == null || this.viewer.getId().length() <= 0) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_ATTR_ID"));
        }
        if (!this.__validateRequesterId()) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.INVALID_ATTR_ID"));
        }
        if (this.pageContext.findAttribute(this.viewer.getId()) != null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.ATTR_ID_DUPLICATE"));
        }
        if (this.viewer.isCustom() && (this.viewer.getName() == null || this.viewer.getName().length() <= 0)) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REQUESTER_NAME"));
        }
        if (this.viewer.getReportDesign() == null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_SOURCE"));
        }
        if (this.viewer.getReportletId() != null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_DOCUMENT"));
        }
        this.validated = Boolean.TRUE;
        return true;
    }

    protected boolean __validateRequesterId() {
        Pattern p = Pattern.compile("^\\w+$");
        Matcher m = p.matcher(this.viewer.getId());
        return m.find();
    }

    @Override
    protected void __beforeEndTag() {
        this.pageContext.setAttribute(this.viewer.getId(), (Object)this.viewer.getId());
    }

    @Override
    public void __process() throws Exception {
        if (this.viewer.isCustom()) {
            JspWriter writer = this.pageContext.getOut();
            writer.write("</form>\n");
            writer.write("</div>\n");
        } else {
            this.__handleIFrame();
        }
    }

    protected void __handleIFrame() throws Exception {
        JspWriter writer = this.pageContext.getOut();
        String iframe = "<iframe ";
        if (this.viewer.getId() != null) {
            iframe = iframe + " id=\"" + this.viewer.getId() + "\" ";
        }
        if (this.viewer.getName() != null) {
            iframe = iframe + " name=\"" + this.viewer.getName() + "\" ";
        }
        String src = this.viewer.createURI("parameter", null) + "&" + "__nocache";
        iframe = iframe + " src=\"" + src + "\" ";
        iframe = iframe + " frameborder=\"" + this.viewer.getFrameborder() + "\" ";
        if (this.viewer.getScrolling() != null) {
            iframe = iframe + " scrolling = \"" + this.viewer.getScrolling() + "\" ";
        }
        iframe = iframe + this.__handleAppearance() + "></iframe>\r\n";
        writer.write(iframe);
    }

    protected String __handleAppearance() {
        String style = " style='";
        if (this.viewer.getStyle() != null) {
            style = style + this.viewer.getStyle() + ";";
        }
        if (this.viewer.getPosition() != null) {
            style = style + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            style = style + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            style = style + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            style = style + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            style = style + "left:" + this.viewer.getLeft() + "px;";
        }
        style = style + "' ";
        return style;
    }

    protected String __handleDivAppearance() {
        String style = " style='";
        if (this.viewer.getPosition() != null) {
            style = style + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            style = style + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            style = style + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            style = style + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            style = style + "left:" + this.viewer.getLeft() + "px;";
        }
        style = this.viewer.getScrolling() != null && "yes".equalsIgnoreCase(this.viewer.getScrolling()) ? style + "overflow:scroll" : style + "overflow:auto";
        if (this.viewer.getStyle() != null) {
            style = style + this.viewer.getStyle() + ";";
        }
        style = style + "' ";
        return style;
    }

    public void setId(String id) {
        this.viewer.setId(id);
    }

    public void setName(String name) {
        this.viewer.setName(name);
    }

    public void setTitle(String title) {
        this.viewer.setTitle(title);
    }

    public void setBaseURL(String baseURL) {
        this.viewer.setBaseURL(baseURL);
    }

    public void setIsCustom(String isCustom) {
        this.viewer.setCustom(Boolean.valueOf(isCustom));
    }

    public void setScrolling(String scrolling) {
        this.viewer.setScrolling(scrolling);
    }

    public void setPosition(String position) {
        this.viewer.setPosition(position);
    }

    public void setStyle(String style) {
        this.viewer.setStyle(style);
    }

    public void setHeight(String height) {
        this.viewer.setHeight(Integer.parseInt(height));
    }

    public void setWidth(String width) {
        this.viewer.setWidth(Integer.parseInt(width));
    }

    public void setLeft(String left) {
        this.viewer.setLeft("" + Integer.parseInt(left));
    }

    public void setTop(String top) {
        this.viewer.setTop("" + Integer.parseInt(top));
    }

    public void setFrameborder(String frameborder) {
        this.viewer.setFrameborder(frameborder);
    }

    public void setReportDesign(String reportDesign) {
        this.viewer.setReportDesign(reportDesign);
    }

    public void setReportDocument(String reportDocument) {
        this.viewer.setReportDocument(reportDocument);
    }

    public void setReportletId(String reportletId) {
        this.viewer.setReportletId(reportletId);
    }

    public void setPattern(String pattern) {
        this.viewer.setPattern(pattern);
    }

    public void setTarget(String target) {
        this.viewer.setTarget(target);
    }

    public void setBookmark(String bookmark) {
        this.viewer.setBookmark(bookmark);
    }

    public void setLocale(String locale) {
        this.viewer.setLocale(locale);
    }

    public void setTimeZone(String timeZone) {
        this.viewer.setTimeZone(timeZone);
    }

    public void setFormat(String format) {
        this.viewer.setFormat(format);
    }

    public void setEmitterId(String emitterId) {
        this.viewer.setEmitterId(emitterId);
    }

    public void setPageOverflow(String pageOverflow) {
        this.viewer.setPageOverflow(pageOverflow);
    }

    public void setSvg(String svg) {
        this.viewer.setSvg(BirtTagUtil.convertBooleanValue(svg));
    }

    public void setRtl(String rtl) {
        this.viewer.setRtl(BirtTagUtil.convertBooleanValue(rtl));
    }

    public void setResourceFolder(String resourceFolder) {
        this.viewer.setResourceFolder(resourceFolder);
    }

    public void setForceOverwriteDocument(String forceOverwriteDocument) {
        this.viewer.setForceOverwriteDocument(BirtTagUtil.convertBooleanValue(forceOverwriteDocument));
    }

    public void setShowTitle(String showTitle) {
        this.viewer.setShowTitle(BirtTagUtil.convertBooleanValue(showTitle));
    }

    public void setShowToolBar(String showToolBar) {
        this.viewer.setShowToolBar(BirtTagUtil.convertBooleanValue(showToolBar));
    }

    public void setShowNavigationBar(String showNavigationBar) {
        this.viewer.setShowNavigationBar(BirtTagUtil.convertBooleanValue(showNavigationBar));
    }

    public void setIsReportlet(String isReportlet) {
        this.viewer.setIsReportlet(BirtTagUtil.convertBooleanValue(isReportlet));
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map getParameters() {
        return this.parameters;
    }
}

