/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.session;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.IViewingSessionManager;
import org.eclipse.birt.report.session.ViewingCache;
import org.eclipse.birt.report.session.ViewingSession;
import org.eclipse.birt.report.session.ViewingSessionConfig;

public class ViewingSessionManager
implements IViewingSessionManager,
HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = -7623325281275814412L;
    private ViewingCache viewingCache;
    private long nextCleanupTime;
    private Map<String, IViewingSession> sessions;
    private String httpSessionId;
    private boolean expired;
    private int sessionCountThreshold;
    private ViewingSessionConfig config;

    public ViewingSessionManager(ViewingCache viewingCache, String httpSessionId, ViewingSessionConfig config) {
        this.httpSessionId = httpSessionId;
        this.viewingCache = viewingCache;
        this.config = config;
        this.sessionCountThreshold = config.getMinimumSessionCountThreshold();
        this.sessions = new LinkedHashMap<String, IViewingSession>(config.getMinimumSessionCountThreshold(), config.getSessionCountThresholdFactor(), true);
        this.expired = false;
        this.nextCleanupTime = new Date().getTime() + config.getSessionTimeout() * 1000L;
    }

    public ViewingCache getCacheManager() {
        return this.viewingCache;
    }

    @Override
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    @Override
    public synchronized IViewingSession createSession() throws ViewerException {
        this.checkExpired();
        this.cleanUp();
        if (this.config.getMaximumSessionCount() > 0 && this.sessions.size() >= this.config.getMaximumSessionCount()) {
            switch (this.config.getMaxSessionCountPolicy()) {
                case SESSION_POLICY_DISCARD_NEW: {
                    throw new ViewerException(BirtResources.getMessage("birt.viewer.error.viewingsessionmaxreached"));
                }
                case SESSION_POLICY_DISCARD_OLDEST: {
                    if (this.deleteOldestSession()) break;
                    throw new ViewerException(BirtResources.getMessage("birt.viewer.error.viewingsessionmaxreached"));
                }
            }
        }
        ViewingSessionWrapper newSession = new ViewingSessionWrapper(this, new ViewingSession(this.httpSessionId, this.viewingCache));
        this.sessions.put(newSession.getId(), newSession);
        return newSession;
    }

    @Override
    public synchronized IViewingSession getSession(String id) {
        this.checkExpired();
        ViewingSessionWrapper session = (ViewingSessionWrapper)this.sessions.get(id);
        if (session != null) {
            session.getWrappedSession().refresh();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void invalidate() {
        if (this.expired) {
            return;
        }
        this.expired = true;
        try {
            for (Map.Entry<String, IViewingSession> entry : this.sessions.entrySet()) {
                IViewingSession session = ((ViewingSessionWrapper)entry.getValue()).getWrappedSession();
                if (session.isExpired()) continue;
                while (session.isLocked()) {
                    session.unlock();
                }
                session.invalidate();
            }
        }
        finally {
            this.viewingCache.clearSession(this.httpSessionId, null);
            this.sessions.clear();
        }
    }

    private synchronized void refreshSession(IViewingSession session) {
        this.sessions.get(session.getId());
        session.refresh();
    }

    public synchronized void removeSession(String id) {
        this.sessions.remove(id);
    }

    private synchronized void cleanUp() {
        long now = new Date().getTime();
        if (now >= this.nextCleanupTime || this.sessions.size() > this.sessionCountThreshold) {
            this.doCleanup();
            if (this.sessions.size() > 0) {
                IViewingSession oldestSession = this.sessions.values().iterator().next();
                this.nextCleanupTime = oldestSession.getLastAccess().getTime() + this.config.getSessionTimeout() * 1000L;
            } else {
                this.nextCleanupTime = now + this.config.getSessionTimeout() * 1000L;
            }
            int minimumThreshold = this.config.getMinimumSessionCountThreshold();
            float factor = this.config.getSessionCountThresholdFactor();
            this.sessionCountThreshold = this.sessions.size() + (int)((float)this.sessions.size() * factor);
            if (this.sessionCountThreshold < minimumThreshold) {
                this.sessionCountThreshold = minimumThreshold;
            }
        }
    }

    private synchronized void doCleanup() {
        Map.Entry<String, IViewingSession> entry;
        IViewingSession session;
        Date lastAccess;
        if (this.sessions.size() == 0) {
            return;
        }
        long sessionTimeout = this.config.getSessionTimeout() * 1000L;
        long currentTime = new Date().getTime() - sessionTimeout;
        Iterator<Map.Entry<String, IViewingSession>> i = this.sessions.entrySet().iterator();
        while (i.hasNext() && currentTime >= (lastAccess = (session = (entry = i.next()).getValue()).getLastAccess()).getTime() && !session.isLocked()) {
            if (!session.isExpired()) {
                ((ViewingSessionWrapper)session).getWrappedSession().invalidate();
            }
            i.remove();
        }
    }

    private boolean deleteOldestSession() {
        Iterator<Map.Entry<String, IViewingSession>> i = this.sessions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, IViewingSession> entry = i.next();
            IViewingSession session = entry.getValue();
            if (session.isLocked()) continue;
            ((ViewingSessionWrapper)session).getWrappedSession().invalidate();
            i.remove();
            return true;
        }
        return false;
    }

    private void checkExpired() {
        if (this.expired) {
            throw new IllegalStateException(BirtResources.getMessage("birt.viewer.error.viewingsessionexpired"));
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        ViewingSessionManager viewingSessionManager = this;
        synchronized (viewingSessionManager) {
            if (!this.expired) {
                this.invalidate();
            }
        }
    }

    private static class ViewingSessionWrapper
    implements IViewingSession,
    Serializable {
        private static final long serialVersionUID = -5837896305154946951L;
        private IViewingSession session;
        private ViewingSessionManager manager;

        public ViewingSessionWrapper(ViewingSessionManager manager, IViewingSession session) {
            this.manager = manager;
            this.session = session;
        }

        public IViewingSession getWrappedSession() {
            return this.session;
        }

        @Override
        public String getCachedReportDocument(String reportFile, String viewerId) {
            return this.session.getCachedReportDocument(reportFile, viewerId);
        }

        @Override
        public String getId() {
            return this.session.getId();
        }

        @Override
        public String getImageTempFolder() {
            return this.session.getImageTempFolder();
        }

        @Override
        public Date getLastAccess() {
            return this.session.getLastAccess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            ViewingSessionManager viewingSessionManager = this.manager;
            synchronized (viewingSessionManager) {
                this.session.invalidate();
                this.manager.sessions.remove(this.session.getId());
            }
        }

        @Override
        public boolean isExpired() {
            return this.session.isExpired();
        }

        @Override
        public boolean isLocked() {
            return this.session.isLocked();
        }

        @Override
        public void lock() {
            this.session.lock();
        }

        @Override
        public void unlock() {
            this.session.unlock();
            this.manager.refreshSession(this.session);
            this.manager.cleanUp();
        }

        @Override
        public void refresh() {
            this.manager.refreshSession(this.session);
        }
    }
}

