/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.service.api.IViewerReportService;

public abstract class AbstractBaseFragment
implements IFragment {
    protected String JSPRootPath = null;
    protected ArrayList children = new ArrayList();

    protected abstract String doPostService(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected abstract IViewerReportService getReportService();

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BirtException {
        this.doPreService(request, response);
        this.doService(request, response);
        String target = this.doPostService(request, response);
        if (target != null && target.length() > 0) {
            RequestDispatcher rd = request.getRequestDispatcher(target);
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Override
    public void callBack(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BirtException {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                IFragment fragment = (IFragment)this.children.get(i);
                if (fragment == null) continue;
                fragment.service(request, response);
            }
        }
    }

    protected void doPreService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=utf-8");
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BirtException {
        request.setAttribute("fragment", (Object)this);
    }

    @Override
    public String getClientId() {
        return null;
    }

    @Override
    public String getClientName() {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public Collection getChildren() {
        return this.children;
    }

    @Override
    public void addChild(IFragment child) {
        this.children.add(child);
    }

    @Override
    public void buildComposite() {
        this.build();
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((IFragment)i.next()).buildComposite();
            }
        }
    }

    protected void build() {
    }

    @Override
    public void setJSPRootPath(String rootPath) {
        this.JSPRootPath = rootPath;
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((IFragment)i.next()).setJSPRootPath(rootPath);
            }
        }
    }

    @Override
    public String getJSPRootPath() {
        return this.JSPRootPath;
    }
}

