/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.lang.dsl;

import java.util.Map;
import java.util.regex.Pattern;
import org.drools.drl.parser.lang.dsl.AbstractDSLMappingEntry;
import org.drools.drl.parser.lang.dsl.DSLMappingEntry;

public class AntlrDSLMappingEntry
extends AbstractDSLMappingEntry {
    public AntlrDSLMappingEntry() {
        this(ANY, EMPTY_METADATA, null, null, null, null);
    }

    public AntlrDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value, String keyPattern, String valuePattern) {
        this.setSection(section);
        this.setMetaData(metadata);
        this.setMappingKey(key);
        this.setMappingValue(value);
        this.setKeyPattern(keyPattern);
        this.setValuePattern(valuePattern);
    }

    public void setKeyPattern(String keyPat) {
        if (keyPat != null) {
            String trimmed = keyPat.trim();
            Object keyPattern = trimmed.replaceAll("\\$", "\\\\\\$");
            if (!((String)(keyPattern = ((String)keyPattern).replaceAll("\\\\#", "#"))).startsWith("^")) {
                keyPattern = "(?:(?<=^)|(?<=\\W))" + (String)keyPattern;
            }
            keyPattern = ((String)keyPattern).endsWith("(.*?)") ? (String)keyPattern + "$" : (String)keyPattern + "(?=\\W|$)";
            this.fixVariableOffsets();
            if (trimmed.startsWith("-") && !trimmed.startsWith("-\\s*")) {
                int index = ((String)keyPattern).indexOf(45) + 1;
                keyPattern = ((String)keyPattern).substring(0, index) + "\\s*" + ((String)keyPattern).substring(index).trim();
            }
            keyPattern = ((String)keyPattern).replaceAll("\\s+", "\\\\s+");
            keyPattern = ((String)keyPattern).replaceAll("(\\\\s\\+)+", "\\\\s+");
            this.setKeyPattern(Pattern.compile((String)keyPattern, 40));
        } else {
            this.setKeyPattern((Pattern)null);
        }
    }

    private void fixVariableOffsets() {
        char[] input = this.getMappingKey().toCharArray();
        int counter = 1;
        boolean insideCurly = false;
        block6: for (int i = 0; i < input.length; ++i) {
            switch (input[i]) {
                case '\\': {
                    ++i;
                    continue block6;
                }
                case '(': {
                    if (insideCurly || i != input.length - 1 && input[i + 1] == '?') continue block6;
                    ++counter;
                    continue block6;
                }
                case '{': {
                    if (insideCurly) {
                        i = AntlrDSLMappingEntry.balancedCapture(input, i, '{');
                        continue block6;
                    }
                    insideCurly = true;
                    this.updateVariableIndex(i, counter);
                    ++counter;
                    continue block6;
                }
                case '}': {
                    if (!insideCurly) continue block6;
                    insideCurly = false;
                }
            }
        }
    }

    private void updateVariableIndex(int offset, int counter) {
        String subs = this.getMappingKey().substring(offset);
        for (Map.Entry<String, Integer> entry : this.getVariables().entrySet()) {
            if (!subs.startsWith("{" + entry.getKey()) || subs.charAt(entry.getKey().length() + 1) != '}' && subs.charAt(entry.getKey().length() + 1) != ':') continue;
            entry.setValue(counter);
            break;
        }
    }

    @Override
    public void setValuePattern(String value) {
        if (value != null) {
            StringBuilder valuePatternBuffer = new StringBuilder();
            valuePatternBuffer.append(value);
            if (value.endsWith(" ")) {
                valuePatternBuffer.deleteCharAt(valuePatternBuffer.length() - 1);
            }
            String pat = valuePatternBuffer.toString().replaceAll("\\\\(#|\\{|\\})", "$1").replaceAll("\\\\n", "\n").replaceAll("\\\\\\$", "\\$");
            super.setValuePattern(pat);
        }
    }

    private static int balancedCapture(char[] chars, int start, char type) {
        return AntlrDSLMappingEntry.balancedCapture(chars, start, chars.length, type);
    }

    private static int balancedCapture(char[] chars, int start, int end, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < end) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < end) {
                block32: {
                    if (start < end && chars[start] == '/') {
                        if (start + 1 == end) {
                            return start;
                        }
                        if (chars[start + 1] == '/') {
                            ++start;
                            while (start < end && chars[start] != '\n') {
                                ++start;
                            }
                        } else if (chars[start + 1] == '*') {
                            start += 2;
                            block16: while (start < end) {
                                switch (chars[start]) {
                                    case '*': {
                                        if (start + 1 < end && chars[start + 1] == '/') break block32;
                                    }
                                    default: {
                                        ++start;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                if (start == end) {
                    return start;
                }
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = AntlrDSLMappingEntry.captureStringLiteral(chars[start], chars, start, end);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new RuntimeException("unbalanced braces [ ... ]");
            }
            case '{': {
                throw new RuntimeException("unbalanced braces { ... }");
            }
            case '(': {
                throw new RuntimeException("unbalanced braces ( ... )");
            }
        }
        throw new RuntimeException("unterminated string literal");
    }

    private static int captureStringLiteral(char type, char[] expr, int cursor, int end) {
        while (++cursor < end && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= end || expr[cursor] != type) {
            throw new RuntimeException("unterminated string literal");
        }
        return cursor;
    }
}

