/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.commands.jaxb.JaxbListAdapter;
import org.drools.commands.jaxb.JaxbListWrapper;
import org.drools.commands.jaxb.JaxbStringObjectPair;
import org.drools.core.QueryResultsImpl;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.rule.Declaration;
import org.drools.core.runtime.rule.impl.FlatQueryResultRow;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="query-results")
@XmlRootElement
@XmlSeeAlso(value={DisconnectedFactHandle.class, JaxbListWrapper.class, JaxbStringObjectPair.class})
public class FlatQueryResults
implements QueryResults {
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbListAdapter.class)
    private ArrayList<Map<String, FactHandle>> idFactHandleMaps;
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbListAdapter.class)
    private ArrayList<Map<String, Object>> idResultMaps;
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbListAdapter.class)
    private Set<String> identifiers = null;

    public FlatQueryResults() {
    }

    public FlatQueryResults(Set<String> identifiers, ArrayList<Map<String, FactHandle>> idFactHandleMaps, ArrayList<Map<String, Object>> factHandleResultMaps) {
        this.identifiers = identifiers;
        this.idFactHandleMaps = idFactHandleMaps;
        this.idResultMaps = factHandleResultMaps;
    }

    public FlatQueryResults(QueryResultsImpl results) {
        Declaration[] parameters = results.getParameters();
        this.identifiers = new HashSet<String>();
        for (Declaration declr : parameters) {
            this.identifiers.add(declr.getIdentifier());
        }
        ArrayList declrCollection = new ArrayList(results.getDeclarations(0).values());
        Iterator it = declrCollection.iterator();
        while (it.hasNext()) {
            Declaration declr = (Declaration)it.next();
            if (this.identifiers.add(declr.getIdentifier())) continue;
            it.remove();
        }
        Declaration[] declrs = new Declaration[parameters.length + declrCollection.size()];
        int i = 0;
        for (Declaration declr : parameters) {
            declrs[i++] = declr;
        }
        for (Declaration declr : declrCollection) {
            declrs[i++] = declr;
        }
        int length = declrs.length;
        this.idFactHandleMaps = new ArrayList();
        this.idResultMaps = new ArrayList();
        for (QueryResultsRow result : results) {
            QueryResultsRowImpl resultImpl = (QueryResultsRowImpl)result;
            HashMap<String, FactHandle> idFactHandleMap = new HashMap<String, FactHandle>(length);
            HashMap<String, Object> idResultMap = new HashMap<String, Object>(length);
            for (i = 0; i < length; ++i) {
                String id = declrs[i].getIdentifier();
                FactHandle factHandle = resultImpl.getFactHandle(id);
                if (factHandle == null) continue;
                Object obj = null;
                if (!id.equals("")) {
                    obj = resultImpl.get(id);
                }
                factHandle = FlatQueryResults.newFrom(factHandle);
                idFactHandleMap.put(id, factHandle);
                idResultMap.put(id, obj);
            }
            this.idFactHandleMaps.add(idFactHandleMap);
            this.idResultMaps.add(idResultMap);
        }
    }

    public static DisconnectedFactHandle newFrom(FactHandle handle) {
        if (handle instanceof DisconnectedFactHandle) {
            return (DisconnectedFactHandle)handle;
        }
        InternalFactHandle ifh = (InternalFactHandle)handle;
        return new DisconnectedFactHandle(ifh.getId(), ifh.getIdentityHashCode(), ifh.getObjectHashCode(), ifh.getRecency(), ifh.getEntryPointName(), null, ifh.isTraitOrTraitable());
    }

    public String[] getIdentifiers() {
        if (this.identifiers == null) {
            return new String[0];
        }
        return this.identifiers.toArray(new String[this.identifiers.size()]);
    }

    public int size() {
        return this.idFactHandleMaps.size();
    }

    public Iterator<QueryResultsRow> iterator() {
        return new QueryResultsIterator(this.idFactHandleMaps.iterator(), this.idResultMaps.iterator());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlatQueryResults)) {
            return false;
        }
        FlatQueryResults that = (FlatQueryResults)o;
        if (this.idFactHandleMaps != null ? !this.idFactHandleMaps.equals(that.idFactHandleMaps) : that.idFactHandleMaps != null) {
            return false;
        }
        if (this.idResultMaps != null ? !this.idResultMaps.equals(that.idResultMaps) : that.idResultMaps != null) {
            return false;
        }
        return !(this.identifiers == null ? that.identifiers != null : !this.identifiers.equals(that.identifiers));
    }

    public int hashCode() {
        int result = this.idFactHandleMaps != null ? this.idFactHandleMaps.hashCode() : 0;
        result = 31 * result + (this.idResultMaps != null ? this.idResultMaps.hashCode() : 0);
        result = 31 * result + (this.identifiers != null ? this.identifiers.hashCode() : 0);
        return result;
    }

    private static class QueryResultsIterator
    implements Iterator<QueryResultsRow> {
        private Iterator<Map<String, FactHandle>> handleIterator;
        private Iterator<Map<String, Object>> iterator;

        public QueryResultsIterator(Iterator<Map<String, FactHandle>> handleIterator, Iterator<Map<String, Object>> iterator) {
            this.handleIterator = handleIterator;
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResultsRow next() {
            return new FlatQueryResultRow(this.handleIterator.next(), this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

