/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.rocketmq;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.mq.Consumer;
import org.dromara.hutool.extra.mq.MQConfig;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.Producer;
import org.dromara.hutool.extra.mq.engine.MQEngine;
import org.dromara.hutool.extra.mq.engine.rocketmq.RocketMQConsumer;
import org.dromara.hutool.extra.mq.engine.rocketmq.RocketMQProducer;

public class RocketMQEngine
implements MQEngine {
    private MQConfig config;
    private String producerGroup;
    private String consumerGroup;

    public RocketMQEngine() {
        Assert.notNull(Message.class);
        this.producerGroup = "DEFAULT_PRODUCER";
        this.consumerGroup = "DEFAULT_CONSUMER";
    }

    public RocketMQEngine setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
        return this;
    }

    public RocketMQEngine setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    @Override
    public RocketMQEngine init(MQConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Producer getProducer() {
        DefaultMQProducer defaultMQProducer = new DefaultMQProducer(this.producerGroup);
        defaultMQProducer.setNamesrvAddr(this.config.getBrokerUrl());
        try {
            defaultMQProducer.start();
        }
        catch (MQClientException e) {
            throw new MQException(e);
        }
        return new RocketMQProducer((MQProducer)defaultMQProducer);
    }

    @Override
    public Consumer getConsumer() {
        DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup);
        defaultMQPushConsumer.setNamesrvAddr(this.config.getBrokerUrl());
        return new RocketMQConsumer((MQPushConsumer)defaultMQPushConsumer);
    }
}

