/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.CommonClientConfigs;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.mq.Consumer;
import org.dromara.hutool.extra.mq.MQConfig;
import org.dromara.hutool.extra.mq.Producer;
import org.dromara.hutool.extra.mq.engine.MQEngine;
import org.dromara.hutool.extra.mq.engine.kafka.KafkaConsumer;
import org.dromara.hutool.extra.mq.engine.kafka.KafkaProducer;

public class KafkaEngine
implements MQEngine {
    private Properties properties;

    public KafkaEngine() {
        Assert.notNull(CommonClientConfigs.class);
    }

    public KafkaEngine(MQConfig config) {
        this.init(config);
    }

    public KafkaEngine(Properties properties) {
        this.init(properties);
    }

    @Override
    public KafkaEngine init(MQConfig config) {
        return this.init(KafkaEngine.buidProperties(config));
    }

    public KafkaEngine init(Properties properties) {
        this.properties = properties;
        return this;
    }

    public KafkaEngine addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Producer getProducer() {
        return new KafkaProducer(this.properties);
    }

    @Override
    public Consumer getConsumer() {
        return new KafkaConsumer(this.properties);
    }

    private static Properties buidProperties(MQConfig config) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", config.getBrokerUrl());
        properties.putAll((Map<?, ?>)config.getProperties());
        return properties;
    }
}

