/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.ofd;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.ofdrw.font.Font;
import org.ofdrw.layout.OFDDoc;
import org.ofdrw.layout.edit.Annotation;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.Img;
import org.ofdrw.layout.element.Paragraph;
import org.ofdrw.reader.OFDReader;

public class OfdWriter
implements Serializable,
Closeable {
    private static final long serialVersionUID = 1L;
    private final OFDDoc doc;

    public OfdWriter(File file) {
        this(file.toPath());
    }

    public OfdWriter(Path file) {
        try {
            this.doc = PathUtil.exists(file, true) ? new OFDDoc(new OFDReader(file), file) : new OFDDoc(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public OfdWriter(OutputStream out) {
        this.doc = new OFDDoc(out);
    }

    public OfdWriter addText(Font font, String ... texts) {
        Paragraph paragraph = new Paragraph();
        if (null != font) {
            paragraph.setDefaultFont(font);
        }
        for (String text : texts) {
            paragraph.add(text);
        }
        return this.add((Div)paragraph);
    }

    public OfdWriter addPicture(File picFile, int width, int height) {
        return this.addPicture(picFile.toPath(), width, height);
    }

    public OfdWriter addPicture(Path picFile, int width, int height) {
        Img img;
        try {
            img = new Img((double)width, (double)height, picFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this.add((Div)img);
    }

    public OfdWriter add(Div div) {
        this.doc.add(div);
        return this;
    }

    public OfdWriter add(int page, Annotation annotation) {
        try {
            this.doc.addAnnotation(page, annotation);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.doc});
    }
}

