/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.dromara.hutool.core.func.LambdaInfo;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONGetter;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.support.InternalJSONUtil;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONObject
extends MapWrapper<String, JSON>
implements JSON,
JSONGetter<String> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_CAPACITY = 16;
    private final JSONFactory factory;

    public JSONObject() {
        this(16);
    }

    public JSONObject(int capacity) {
        this(capacity, JSONFactory.getInstance());
    }

    public JSONObject(JSONConfig config) {
        this(16, config);
    }

    public JSONObject(int capacity, JSONConfig config) {
        this(capacity, JSONFactory.of(config, null));
    }

    public JSONObject(int capacity, JSONFactory factory) {
        super(InternalJSONUtil.createRawMap(capacity, factory));
        this.factory = factory;
    }

    @Override
    public JSONFactory getFactory() {
        return this.factory;
    }

    @Override
    public void write(JSONWriter writer) throws JSONException {
        writer.beginObj();
        this.forEach((? super K key, ? super V value) -> writer.writeField(new MutableEntry<Object, Object>(key, value)));
        writer.endObj();
    }

    public <P, T> T get(SerFunction<P, T> func) {
        LambdaInfo lambdaInfo = LambdaUtil.resolve(func);
        return this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        JSON json = (JSON)this.get(key);
        Object value = json instanceof JSONPrimitive ? ((JSONPrimitive)json).getValue() : json;
        return ObjUtil.defaultIfNull(value, defaultValue);
    }

    @Override
    public JSON getJSON(String key) {
        return (JSON)this.get(key);
    }

    public JSONObject increment(String key) throws JSONException {
        JSONPrimitive jsonPrimitive;
        JSON json = (JSON)this.get(key);
        if (null == json) {
            return this.putValue(key, 1);
        }
        if (json instanceof JSONPrimitive && (jsonPrimitive = (JSONPrimitive)json).isNumber()) {
            jsonPrimitive.increment();
            return this;
        }
        throw new JSONException("Unable to increment key: {} type: {}", key, json.getClass());
    }

    public JSONObject append(String key, Object value) throws JSONException {
        Object object = this.getObj(key);
        if (object == null) {
            this.putValue(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).addValue(value);
        } else {
            this.putValue(key, this.factory.ofArray().addValue(object).addValue(value));
        }
        return this;
    }

    public JSONObject putFields(SerSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.putValue(LambdaUtil.getFieldName(f), f.get()));
        return this;
    }

    public JSONObject putAllValue(Map<?, ?> map) {
        if (MapUtil.isNotEmpty(map)) {
            map.forEach((? super K key, ? super V value) -> this.putValue(StrUtil.toStringOrNull(key), value));
        }
        return this;
    }

    public JSONObject putNull(String key) {
        this.put(key, null);
        return this;
    }

    public JSONObject putValue(String key, Boolean value) throws JSONException {
        this.put(key, this.factory.ofPrimitive(value));
        return this;
    }

    public JSONObject putValue(String key, Number value) throws JSONException {
        this.put(key, this.factory.ofPrimitive(value));
        return this;
    }

    public JSONObject putValue(String key, Character value) throws JSONException {
        this.put(key, this.factory.ofPrimitive(value));
        return this;
    }

    public JSONObject putValue(String key, String value) throws JSONException {
        this.put(key, this.factory.ofPrimitive(value));
        return this;
    }

    public JSONObject putValue(String key, Object value) throws JSONException {
        if (null == value) {
            return this.putNull(key);
        }
        this.put(key, this.factory.getMapper().toJSON(value, false));
        return this;
    }

    @Override
    public JSON put(String key, JSON value) throws JSONException {
        if (null == key) {
            return null;
        }
        JSONConfig config = this.config();
        if (null == value && config.isIgnoreNullValue()) {
            return (JSON)this.remove(key);
        }
        JSONConfig.DuplicateMode duplicateMode = config.getDuplicateMode();
        if (JSONConfig.DuplicateMode.OVERRIDE != duplicateMode && this.containsKey(key)) {
            if (JSONConfig.DuplicateMode.IGNORE == duplicateMode) {
                return null;
            }
            throw new JSONException("Duplicate key \"{}\"", key);
        }
        return super.put(key, value);
    }

    public <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType) {
        return (Map)this.toBean(TypeUtil.createParameterizedType(Map.class, new Type[]{keyType, valueType}));
    }

    @Override
    public String toString() {
        return this.toJSONString(0);
    }
}

