/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.jetty;

import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.AbstractServerEngine;
import org.dromara.hutool.http.server.engine.jetty.Jetty9Handler;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyEngine
extends AbstractServerEngine {
    private Server server;
    private Handler jettyHandler;

    public JettyEngine() {
        Assert.notNull(Server.class);
    }

    public JettyEngine setJettyHandler(Handler jettyHandler) {
        this.jettyHandler = jettyHandler;
        return this;
    }

    @Override
    public void start() {
        this.initEngine();
        try {
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    public Server getRawEngine() {
        return this.server;
    }

    @Override
    protected void reset() {
        if (null != this.server) {
            this.server.destroy();
            this.server = null;
        }
    }

    @Override
    protected void initEngine() {
        long idleTimeout;
        int maxThreads;
        if (null != this.server) {
            return;
        }
        ServerConfig config = this.config;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("Hutool");
        int coreThreads = config.getCoreThreads();
        if (coreThreads > 0) {
            threadPool.setMinThreads(coreThreads);
        }
        if ((maxThreads = config.getMaxThreads()) > 0) {
            threadPool.setMaxThreads(maxThreads);
        }
        if ((idleTimeout = config.getIdleTimeout()) > 0L) {
            threadPool.setIdleTimeout((int)idleTimeout);
        }
        Server server = new Server((ThreadPool)threadPool);
        server.addConnector((Connector)this.createConnector(server));
        server.setHandler(ObjUtil.defaultIfNull(this.jettyHandler, () -> new Jetty9Handler(this.handler)));
        this.server = server;
    }

    private ServerConnector createConnector(Server server) {
        ServerConnector connector;
        ServerConfig config = this.config;
        HttpConnectionFactory connectionFactory = JettyEngine.createHttpConnectionFactory(config);
        SSLContext sslContext = config.getSslContext();
        if (null != sslContext) {
            SslConnectionFactory sslConnectionFactory = JettyEngine.createSslConnectionFactory(sslContext);
            connector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, connectionFactory});
        } else {
            connector = new ServerConnector(server, new ConnectionFactory[]{connectionFactory});
        }
        long idleTimeout = config.getIdleTimeout();
        if (idleTimeout > 0L) {
            connector.setIdleTimeout(idleTimeout);
        }
        connector.setHost(config.getHost());
        connector.setPort(config.getPort());
        return connector;
    }

    private static HttpConnectionFactory createHttpConnectionFactory(ServerConfig config) {
        HttpConfiguration configuration = new HttpConfiguration();
        int maxHeaderSize = config.getMaxHeaderSize();
        if (maxHeaderSize > 0) {
            configuration.setRequestHeaderSize(maxHeaderSize);
        }
        return new HttpConnectionFactory(configuration);
    }

    private static SslConnectionFactory createSslConnectionFactory(SSLContext sslContext) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setSslContext(sslContext);
        return new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString());
    }
}

