/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.EmptyInputStream;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.GlobalCompressStreamRegister;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.ResponseBody;
import org.dromara.hutool.http.meta.HeaderName;

public class OkHttpResponse
implements Response {
    private final okhttp3.Response rawRes;
    private final Charset requestCharset;
    private final ResponseBody body;

    public OkHttpResponse(okhttp3.Response rawRes, Request message) {
        this.rawRes = rawRes;
        this.requestCharset = message.charset();
        this.body = message.method().isIgnoreBody() ? null : new ResponseBody(this, this.bodyStream());
    }

    @Override
    public int getStatus() {
        return this.rawRes.code();
    }

    @Override
    public String header(String name) {
        return this.rawRes.header(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.rawRes.headers().toMultimap();
    }

    @Override
    public Charset charset() {
        return ObjUtil.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        okhttp3.ResponseBody body = this.rawRes.body();
        if (null == body) {
            return EmptyInputStream.INSTANCE;
        }
        return GlobalCompressStreamRegister.INSTANCE.wrapStream(body.byteStream(), this.rawRes.header(HeaderName.CONTENT_ENCODING.getValue()));
    }

    @Override
    public OkHttpResponse sync() {
        if (null != this.body) {
            this.body.sync();
        }
        IoUtil.closeQuietly(new AutoCloseable[]{this.rawRes});
        return this;
    }

    @Override
    public ResponseBody body() {
        return this.body;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.rawRes});
    }

    public String toString() {
        return HttpUtil.toString(this);
    }
}

