/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.log.LogUtil;

public class ClientEngineFactory {
    public static ClientEngine getEngine() {
        return Singleton.get(ClientEngine.class.getName(), ClientEngineFactory::createEngine);
    }

    public static ClientEngine createEngine(ClientConfig config) {
        return ClientEngineFactory.createEngine().init(config);
    }

    public static ClientEngine createEngine(String engineName) throws HttpException {
        if (!StrUtil.endWithIgnoreCase(engineName, "Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader<ClientEngine> list = SpiUtil.loadList(ClientEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase(serviceName, engineName)) continue;
            return list.getService(serviceName);
        }
        throw new HttpException("No such engine named: " + engineName);
    }

    public static ClientEngine createEngine() {
        ClientEngine engine = SpiUtil.loadFirstAvailable(ClientEngine.class);
        LogUtil.debug("Use [{}] Http Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }
}

