/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.pebble;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.pebble.loader.DelegatingLoader;
import io.pebbletemplates.pebble.loader.FileLoader;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.loader.StringLoader;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.pebble.PebbleTemplate;

public class PebbleTemplateEngine
implements TemplateEngine {
    private PebbleEngine engine;

    public PebbleTemplateEngine() {
        Assert.notNull(PebbleEngine.class);
    }

    public PebbleTemplateEngine(TemplateConfig config) {
        this.init(config);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        this.init(PebbleTemplateEngine.createEngine(config));
        return this;
    }

    private void init(PebbleEngine engine) {
        this.engine = engine;
    }

    private static PebbleEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        ClasspathLoader loader = null;
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                loader = new ClasspathLoader();
                loader.setPrefix(StrUtil.addSuffixIfNot(config.getPath(), "/"));
                break;
            }
            case FILE: {
                loader = new FileLoader();
                loader.setPrefix(StrUtil.addSuffixIfNot(config.getPath(), "/"));
                break;
            }
            case WEB_ROOT: {
                loader = new FileLoader();
                loader.setPrefix(StrUtil.addSuffixIfNot(FileUtil.getAbsolutePath(FileUtil.file(FileUtil.getWebRoot(), config.getPath())), "/"));
                break;
            }
            case STRING: {
                loader = new StringLoader();
                break;
            }
            case COMPOSITE: {
                loader = new DelegatingLoader(ListUtil.of(new ClasspathLoader(), new FileLoader(), new StringLoader()));
            }
        }
        return new PebbleEngine.Builder().loader((Loader)loader).autoEscaping(false).build();
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return PebbleTemplate.wrap(this.engine.getTemplate(resource));
    }

    @Override
    public PebbleEngine getRaw() {
        return this.engine;
    }
}

